% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.plr.R
\name{summary.plr}
\alias{summary.plr}
\title{Summarizing Polygonal Linear Regression}
\usage{
\method{summary}{plr}(object, digits = max(3L, getOption("digits") - 3L),
  ...)
}
\arguments{
\item{object}{an object of the class \code{plr}, usually, a result of a call to \code{\link{plr}}.}

\item{digits}{a non-null value for \code{digits} specifies the minimum number of significant 
digits to be printed in values.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
residuals calculated as the response variable minus the fitted values.

sigma the given by square root of the estimated variance of the random error 
\deqn{\sigma^2 = \frac{\sum{i = 1}^{n} (y_i - \hat{y}_i)^2}{n - p - 1}} where \emph{p} is 
two times the number of independent variables.

call the matched call.

aliased named logical vector showing if the original coefficients are aliased.

terms the \code{\link[stats]{terms}}.

coefficients a p x 4 matrix with columns for the estimated coefficient, 
its standard error, z-statistic and corresponding (two-sided) p-value.
}
\description{
\code{summary} method for class \code{plr}.
}
\examples{
yp <- psim(50, 10) #simulate 50 polygons of 10 sides
xp1 <- psim(50, 10) #simulate 50 polygons of 10 sides
xp2 <- psim(50, 10) #simulate 50 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1 + xp2, data = e)
s <- summary(fit) 
}
