\name{DpiGet}
\alias{DpiGet}
\title{Downloads the Database of Political Institutions (DPI)}
\usage{
DpiGet(url = "http://bit.ly/1jZ3nmM", vars = NULL, OutCountryID = "iso2c",
  standardCountryName = TRUE, na.rm = TRUE, duplicates = "message",
  fromLast = FALSE)
}
\arguments{
  \item{url}{character string. The URL for the Polity IV
  data set you would like to download. Note: the link must
  be to a Stata formated file.}

  \item{vars}{character vector containing the variables to
  keep. If \code{vars = NULL} then the entire data set is
  returned. Note that \code{country} and \code{year}
  variables are always returned.}

  \item{OutCountryID}{character string. The type of country
  ID you would like to include in the output file along
  with the country name. See \code{\link{countrycode}} for
  available options.}

  \item{standardCountryName}{logical. Whether or not to
  standardise the country names variable based on
  \code{country.name} from \code{\link{countrycode}}.}

  \item{na.rm}{logical. Drop observations where
  \code{OutCountryID} is \code{NA}.}

  \item{duplicates}{character specifying how to handle
  duplicated country-year observations. Can be set to
  \code{none} to do nothing, \code{message} to simply
  report duplicates, \code{drop} to report and drop
  duplicates, and \code{return} to return a data frame with
  only duplicated observations (see also \code{fromLast}).}

  \item{fromLast}{logical indicating if duplication should
  be considered from the reverse side. Only relevant if
  \code{duplicates = 'drop'} or \code{duplicates = 'out'}.}
}
\description{
Downloads the Database of Political Institutions (DPI) data
set. It keeps specified variables and creates a standard
country ID variable that can be used for merging the data
with other data sets.
}
\details{
Note: a bit.ly URL is used to shorten the Stata formatted
data set's URL due to CRAN requirements.
}
\examples{
\dontrun{
# Download full data set
DpiData <- DpiGet()

# Create data frame with only the military variable
DpiSub <- DpiGet(vars = 'military',
                 OutCountryID = 'imf')
}
}
\seealso{
\code{\link{countrycode}}, \code{\link{CountryID}},
\code{\link{WinsetCreator}}
}

