% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{mask}
\alias{mask}
\title{Create a pattern matrix for masking}
\usage{
mask(x, y = NULL)
}
\arguments{
\item{x}{a numeric or character vector matched against each other.}

\item{y}{a numeric or character vector matched against \code{x} if provided.}
}
\value{
a sparse logical matrix with \code{TRUE} for matched pairs.
}
\description{
Create a pattern matrix for \code{\link[=simil]{simil()}} or \code{\link[=dist]{dist()}} to enable masked similarity computation.
If the matrix is passed to the function, it computes similarity scores only for cells with \code{TRUE}.
}
\examples{
mt1 <- Matrix::rsparsematrix(100, 6, 1.0)
colnames(mt1) <- c("a", "a", "d", "d", "e", "e")
mt2 <- Matrix::rsparsematrix(100, 5, 1.0)
colnames(mt2) <- c("a", "b", "c", "d", "e")

(msk <- mask(colnames(mt1), colnames(mt2)))
simil(mt1, mt2, margin = 2, mask = msk, drop0 = TRUE)
}
