% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{colSds}
\alias{colSds}
\alias{rowSds}
\title{Standard deviation of columns and rows of large matrices}
\usage{
colSds(x)

rowSds(x)
}
\arguments{
\item{x}{a \link[base:matrix]{base::matrix} or \link[Matrix:Matrix]{Matrix::Matrix} object.}
}
\description{
Produces the same result as \code{apply(x, 1, sd)} or \code{apply(x, 2, sd)}
without coercing matrix to dense matrix. Values are not identical to
\code{sd()} because of the floating point precision issue in C++.
}
\examples{
mt <- Matrix::rsparsematrix(100, 100, 0.01)
colSds(mt)
apply(mt, 2, sd) # the same
}
