% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.minsorting}
\alias{plot.minsorting}
\title{Plot inferred grain size distributions}
\usage{
\method{plot}{minsorting}(x, cumulative = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{minsorting}}

\item{cumulative}{boolean flag indicating whether the grain size
distribution should be plotted as a density or cumulative
probability curve.}

\item{...}{optional parameters (see ?par for details)}
}
\description{
Plot the grain size distributions of the different
minerals under consideration
}
\examples{
data(Namib,densities)
N8 <- subset(Namib$HM,select="N8")
distribution <- minsorting(N8,densities,phi=2,sigmaphi=1,medium="air",by=0.05)
plot(distribution)
}
\seealso{
minsorting
}

