% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{indscal}
\alias{indscal}
\title{Individual Differences Scaling of provenance data}
\usage{
indscal(..., type = "ordinal")
}
\arguments{
\item{...}{a sequence of datasets of class \code{DZdata} or
\code{HMdata}}

\item{type}{is either "ratio", "interval", or "ordinal"}
}
\value{
an object of class \code{INDSCAL}, i.e. a list containing
the following items:

delta: Observed dissimilarities

obsdiss: List of observed dissimilarities, normalized

confdiss: List of configuration dissimilarities

conf: List of matrices of final configurations

gspace: Joint configurations aka group stimulus space

cweights: Configuration weights

stress: Stress-1 value

spp: Stress per point

sps: Stress per subject (matrix)

ndim: Number of dimensions

model: Type of smacof model

niter: Number of iterations

nobj: Number of objects
}
\description{
Performs 3-way Multidimensional Scaling analysis using Carroll and
Chang (1970)'s INdividual Differences SCALing method as implemented
using De Leeuw and Mair (2011)'s stress majorization algorithm.
}
\examples{
DZ <- read.DZdata(system.file("DZ.csv",package="provenance"))
HM <- read.HMdata(system.file("HM.csv",package="provenance"))
plot(indscal(DZ,HM))
}
\author{
Jan de Leeuw and Patrick Mair
}
\references{
de Leeuw, J., & Mair, P. (2009). Multidimensional scaling using
majorization: The R package smacof. Journal of Statistical
Software, 31(3), 1-30, < http://www.jstatsoft.org/v31/i03/>
}

