/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.editor;

import com.qarks.util.ExceptionHelper;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.ui.CharsetCombo;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;

public class TextFileEditorDialog
extends JDialog
implements ActionListener {
    private JTextPane textArea;
    private JButton save;
    private JButton close;
    private File filePath;
    private String lastSavedText;
    private boolean readOnly = false;
    private CharsetCombo charsetChooser;
    private String EOL = System.getProperty("line.separator");

    public TextFileEditorDialog(Window window, String string, boolean bl, File file, boolean bl2, String string2) {
        super(window, string, bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        if (bl2 && !file.canWrite()) {
            this.setTitle(ResourceManager.getString((Object)ResourceKey.READ_ONLY, string));
            this.readOnly = true;
        }
        this.init(file, string2);
    }

    private void init(File file, String string) {
        this.filePath = file;
        super.setDefaultCloseOperation(0);
        this.textArea = new JTextPane();
        this.save = new JButton(ResourceManager.getString((Object)ResourceKey.SAVE));
        this.save.setEnabled(false);
        this.close = new JButton(ResourceManager.getString((Object)ResourceKey.CLOSE));
        this.charsetChooser = new CharsetCombo();
        this.charsetChooser.select(string);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        if (!this.readOnly) {
            jPanel2.add(this.save);
            this.textArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    TextFileEditorDialog.this.checkMustSave();
                }
            });
        } else {
            this.textArea.setEditable(false);
        }
        jPanel2.add(this.close);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)jPanel2, "East");
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel4.add(new JLabel(ResourceManager.getString((Object)ResourceKey.CURRENT_CHARSET)));
        jPanel4.add(this.charsetChooser);
        this.add((Component)jPanel4, "North");
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(jPanel);
        this.setSize(700, 600);
        this.save.addActionListener(this);
        this.close.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (TextFileEditorDialog.this.close.isEnabled()) {
                    TextFileEditorDialog.this.actionPerformed(new ActionEvent(TextFileEditorDialog.this.close, 0, "close"));
                }
            }
        });
        this.charsetChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TextFileEditorDialog.this.reload();
            }
        });
        this.textArea.setCaretPosition(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                TextFileEditorDialog.this.textArea.requestFocus();
            }
        });
        this.reload();
    }

    private void reload() {
        String string = "";
        try {
            string = FileHelper.getFileContent(this.filePath, this.charsetChooser.getSelectedCharset().name());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.lastSavedText = string;
        this.textArea.setText(string);
    }

    private void checkMustSave() {
        if (!this.readOnly) {
            this.save.setEnabled(!this.textArea.getText().equals(this.lastSavedText));
        }
    }

    private void save() throws IOException {
        String string = this.textArea.getText();
        FileHelper.writeContentToFile(string, this.filePath);
        this.save.setEnabled(false);
        this.lastSavedText = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.save) {
            try {
                this.save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.OK)};
                JOptionPane.showOptionDialog(this, ExceptionHelper.getRootMessage(exception), ResourceManager.getString((Object)ResourceKey.SAVE), -1, 0, null, objectArray, objectArray[0]);
            }
        } else if (object == this.close) {
            boolean bl = true;
            if (this.save.isEnabled()) {
                Object[] objectArray = new Object[]{ResourceManager.getString((Object)ResourceKey.YES), ResourceManager.getString((Object)ResourceKey.NO)};
                int n = JOptionPane.showOptionDialog(this, ResourceManager.getString((Object)ResourceKey.CLOSE_WITHOUT_SAVE), ResourceManager.getString((Object)ResourceKey.SAVE), -1, 3, null, objectArray, objectArray[0]);
                boolean bl2 = bl = n == 0;
            }
            if (bl) {
                this.dispose();
            }
        }
    }
}

