% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quorum.R
\name{reached_quorum_total}
\alias{reached_quorum_total}
\title{Check if lists/parties have reached the quorum for all votes}
\usage{
reached_quorum_total(votes_matrix, quorum_total)
}
\arguments{
\item{votes_matrix}{votes matrix}

\item{quorum_total}{Vote threshold a party must reach for all votes cast.
Used as quota of total votes if less than 1, otherwise
as number of votes. Must be greater than 0.}
}
\value{
boolean vector with length equal to the number of lists/parties
(\code{votes_matrix} rows) whether they reached the quorum or not
}
\description{
Base implementation, used by \code{\link[=quorum_any]{quorum_any()}} and \code{\link[=quorum_all]{quorum_all()}}.
}
\examples{
(vm = matrix(c(239, 10, 308, 398, 20, 925), nrow = 3))
reached_quorum_total(vm, 35)
}
\seealso{
\code{\link[=reached_quorum_any_district]{reached_quorum_any_district()}}
}
