% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/522.Error-Failure_Limitbased_CC_All_Graph.R
\name{PloterrCTW}
\alias{PloterrCTW}
\title{Plots the error, long term power and pass/fail criteria for continuity corrected Wald-t method}
\usage{
PloterrCTW(n, alp, phi, c, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{c}{- Continuity correction}

\item{f}{- Failure criterion}
}
\description{
Plots the error, long term power and pass/fail criteria for continuity corrected Wald-t method
}
\details{
Plot of approximate and continuity corrected method based on a t_approximation of the standardized point estimator
using error due to the difference of achieved and nominal level of significance for the \eqn{n + 1} intervals
}
\examples{
n=5; alp=0.05; phi=0.05;c=1/(2*n); f=-2
PloterrCTW(n,alp,phi,c,f)
}
\seealso{
Other Error for continuity corrected methods: \code{\link{PloterrCAS}},
  \code{\link{PloterrCAll}}, \code{\link{PloterrCLT}},
  \code{\link{PloterrCSC}}, \code{\link{PloterrCWD}},
  \code{\link{errCAS}}, \code{\link{errCAll}},
  \code{\link{errCLT}}, \code{\link{errCSC}},
  \code{\link{errCTW}}, \code{\link{errCWD}}
}

