% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/401.p-Confidence_p-Bias_BASE_All.R
\name{pCOpBIAll}
\alias{pCOpBIAll}
\title{Calculates p-confidence and p-bias for a given n and alpha level for 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)}
\usage{
pCOpBIAll(n, alp)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
 \item{method}{   Method}
}
\description{
Calculates p-confidence and p-bias for a given n and alpha level for 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\details{
Evaluation of  p-confidence and p-bias for  the \eqn{n + 1} intervals using 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\examples{
n=5; alp=0.05
pCOpBIAll(n,alp)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of base methods: \code{\link{PlotpCOpBIAS}},
  \code{\link{PlotpCOpBIAll}}, \code{\link{PlotpCOpBIBA}},
  \code{\link{PlotpCOpBIEX}}, \code{\link{PlotpCOpBILR}},
  \code{\link{PlotpCOpBILT}}, \code{\link{PlotpCOpBISC}},
  \code{\link{PlotpCOpBITW}}, \code{\link{PlotpCOpBIWD}},
  \code{\link{pCOpBIAS}}, \code{\link{pCOpBIBA}},
  \code{\link{pCOpBIEX}}, \code{\link{pCOpBILR}},
  \code{\link{pCOpBILT}}, \code{\link{pCOpBISC}},
  \code{\link{pCOpBITW}}, \code{\link{pCOpBIWD}}
}

