% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains_between.R
\name{contains_between}
\alias{contains_between}
\title{Check if activity is present (contained) in a case between  min and max number of times}
\usage{
contains_between(activity, min = 1, max = 1)
}
\arguments{
\item{activity}{Activity too check. Character vector of length one. This should be an activity of the event log supplied with `check_rule`}

\item{min}{The minimum number of times the activity should be present.}

\item{max}{The maximum number of times the activity should be present.}
}
\description{
This rules examines whether the supplied activity is present in a case for a certain interval of times.
The arguments `min` and `max` can be used to specify the allowed interval of occurences.
}
\examples{
library(bupaR)
library(eventdataR)


# A patients should have between 0 and 4 blood tests (including 0 and 4).
patients \%>\%
check_rule(contains_between("Blood test", min = 0, max = 4))

}
\seealso{
Other Declarative Rules: \code{\link{absent}},
  \code{\link{and}}, \code{\link{contains_exactly}},
  \code{\link{contains}}, \code{\link{ends}},
  \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{succession}}, \code{\link{xor}}
}
