% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleMediation.R
\name{multipleMediation}
\alias{multipleMediation}
\title{Make Mediation Equation with multiple X or multiple Y}
\usage{
multipleMediation(
  X = NULL,
  M = NULL,
  Y = NULL,
  labels = list(),
  data = NULL,
  vars = list(),
  moderator = list(),
  covar = NULL,
  mode = 0,
  range = TRUE,
  rangemode = 1,
  serial = FALSE,
  contrast = 1,
  bmatrix = NULL
)
}
\arguments{
\item{X}{Names of independent variable}

\item{M}{Names of mediator variable}

\item{Y}{Names of dependent variable}

\item{labels}{optional list}

\item{data}{A data.frame}

\item{vars}{A list}

\item{moderator}{A list}

\item{covar}{A list of covariates}

\item{mode}{A numeric. 0: SEM equation, 1: regression equation}

\item{range}{A logical}

\item{rangemode}{range mode}

\item{serial}{logical If TRUE, serial variables are added}

\item{contrast}{integer If 2, absolute difference of contrasts are calculated}

\item{bmatrix}{integer specifying causal relations among mediators}
}
\description{
Make Mediation Equation with multiple X or multiple Y
}
\examples{
labels=list(X="cyl",M="am",Y="mpg")
covar=list(name=c("carb","disp"),site=list(c("M","Y"),"Y","Y"))
cat(multipleMediation(labels=labels,covar=covar,data=mtcars))
labels=list(X=c("cyl","wt"),M="am",Y="mpg")
moderator=list(name=c("vs"),site=list(c("a1","b1")))
cat(multipleMediation(labels=labels,data=mtcars))
cat(multipleMediation(labels=labels,moderator=moderator,data=mtcars))
labels=list(X="wt",M=c("cyl","am"),Y="mpg")
moderator=list(name=c("vs"),site=list(c("b1","b2")))
cat(multipleMediation(labels=labels,data=mtcars,range=FALSE))
cat(multipleMediation(labels=labels,moderator=moderator,data=mtcars,range=FALSE))
eq=multipleMediation(labels=labels,moderator=moderator,data=mtcars,range=FALSE,serial=FALSE,mode=1)
drawModel(equation=eq,labels=labels)
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
labels=list(X="X",M=c("M1","M2"),Y="Y")
cat(multipleMediation(labels=labels))
cat(multipleMediation(labels=labels,serial=TRUE))
moderator=list(name=c("W"),site=list(c("a1","b1")))
cat(multipleMediation(labels=labels,moderator=moderator,range=FALSE))
cat(multipleMediation(labels=labels,moderator=moderator,data=mtcars,range=FALSE))
cat(multipleMediation(X="am",Y="mpg",data=mtcars,moderator=moderator,covar=covar))
labels=list(X="cond",M=c("import","pmi"),Y="reaction")
cat(multipleMediation(labels=labels,data=pmi,serial=TRUE))
cat(multipleMediation(labels=labels,data=pmi,contrast=2))
cat(multipleMediation(labels=labels,data=pmi,mode=1,serial=TRUE))
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
cat(multipleMediation(labels=labels,bmatrix=c(1,1,1,1,1,1,1,1,1,1)))
labels=list(X="X",M=c("M1","M2"),Y="Y",W="W")
cat(multipleMediation(labels=labels,bmatrix=c(1,1,1,1,1,0)))
cat(multipleMediation(labels=labels,bmatrix=c(1,1,1,1,0,0)))
moderator=list(name=c("W"),matrix=list(c(1,1,0,1,0,0)))
eq=multipleMediation(labels=labels,moderator=moderator,bmatrix=c(1,1,1,1,1,1),mode=1)
drawModel(equation=eq,labels=labels,nodemode=2)
labels=list(X="X",M=c("M1","M2","M3"),Y="Y",W="W")
cat(multipleMediation(labels=labels,bmatrix=c(1,1,0,0,1,1,1,1,0,1)))
labels=list(X="X",M=c("M1","M2"),Y="Y")
cat(multipleMediation(labels=labels,serial=TRUE,mode=1))
vars=list(name=list(c("W","Z")),matrix=list(c(0,0,1,0,0,0)))
cat(multipleMediation(labels=labels,bmatrix=c(1,1,1,1,1,0),vars=vars))
}
