% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency_matrix.R
\name{adjacency_matrix}
\alias{adjacency_matrix}
\alias{adjacency_matrix.Raster}
\alias{adjacency_matrix.SpatialPolygons}
\alias{adjacency_matrix.SpatialLines}
\alias{adjacency_matrix.SpatialPoints}
\alias{adjacency_matrix.sf}
\alias{adjacency_matrix.default}
\title{Adjacency matrix}
\usage{
adjacency_matrix(x, ...)

\method{adjacency_matrix}{Raster}(x, directions = 4L, ...)

\method{adjacency_matrix}{SpatialPolygons}(x, ...)

\method{adjacency_matrix}{SpatialLines}(x, ...)

\method{adjacency_matrix}{SpatialPoints}(x, ...)

\method{adjacency_matrix}{sf}(x, ...)

\method{adjacency_matrix}{default}(x, ...)
}
\arguments{
\item{x}{\code{\link[raster]{Raster-class}},
\code{\link[sp]{SpatialPolygons-class}},
\code{\link[sp]{SpatialLines-class}},
or \code{\link[sf]{sf}} object
representing planning units.}

\item{...}{not used.}

\item{directions}{\code{integer} If \code{x} is a
\code{\link[raster]{Raster-class}} object, the number of directions
in which cells should be considered adjacent: 4 (rook's case), 8 (queen's
case), 16 (knight and one-cell queen moves), or "bishop" to for cells
with one-cell diagonal moves.}
}
\value{
\code{\link[Matrix]{dsCMatrix-class}} sparse symmetric matrix.
  Each row and column represents a planning unit.
  Cells values indicate if different planning units are
  adjacent to each other or not (using ones and zeros).
  To reduce computational burden, cells among the matrix diagonal are
  set to zero. Furthermore, if the argument to \code{x} is a
  \code{\link[raster]{Raster-class}} object, then cells with \code{NA}
  values are set to zero too.
}
\description{
Create a matrix showing which planning units are spatially adjacent to
each other. Note that this also include planning units that overlap
with each other too.
}
\details{
Spatial processing is completed using
  \code{\link[sf]{st_intersects}} for \code{\link[sp]{Spatial-class}} and
  \code{\link[sf]{sf}} objects,
  and \code{\link[raster]{adjacent}} for \code{\link[raster]{Raster-class}}
  objects.
  Prior to version 5.0.0,  this function was named
  \code{connected_matrix}. It has been renamed to be consistent
  with other spatial association matrix functions.
}
\examples{
# load data
data(sim_pu_raster, sim_pu_sf, sim_pu_lines)

# create adjacency matrix using raster data
## crop raster to 9 cells
r <- crop(sim_pu_raster, c(0, 0.3, 0, 0.3))

## make adjacency matrix
am_raster <- adjacency_matrix(r)

# create adjacency matrix using polygons (sf) data
## subset 9 polygons
ply <- sim_pu_sf[c(1:2, 10:12, 20:22), ]

## make adjacency matrix
am_ply <- adjacency_matrix(ply)

# create adjacency matrix using lines (Spatial) data
## subset 9 lines
lns <- sim_pu_lines[c(1:2, 10:12, 20:22), ]

## make adjacency matrix
am_lns <- adjacency_matrix(lns)

# plot data and the adjacency matrices
\donttest{
par(mfrow = c(4,2))

## plot raster and adjacency matrix
plot(r, main = "raster", axes = FALSE, box = FALSE)
plot(raster(as.matrix(am_raster)), main = "adjacency matrix", axes = FALSE,
     box = FALSE)

## plot polygons (sf) and adjacency matrix
plot(r, main = "polygons (sf)", axes = FALSE, box = FALSE)
plot(raster(as.matrix(am_ply)), main = "adjacency matrix", axes = FALSE,
    box = FALSE)

## plot lines (Spatial) and adjacency matrix
plot(r, main = "lines (Spatial)", axes = FALSE, box = FALSE)
plot(raster(as.matrix(am_lns)), main = "adjacency matrix", axes = FALSE,
     box = FALSE)
}
}
