% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pool_portfolio.R
\name{add_pool_portfolio}
\alias{add_pool_portfolio}
\alias{add_pool_portfolio}
\title{Add a pool portfolio}
\usage{
add_pool_portfolio(x)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}
}
\value{
\code{\link{ConservationProblem-class}} object with the portfolio
  added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
\code{\link{problem}} by extracting all the feasible solutions
discovered during the optimization process.
}
\details{
This strategy for generating a portfolio requires problems to
  be solved using the \emph{Gurobi} software suite (i.e. using
  \code{\link{add_gurobi_solver}}. Specifically, version 8.0.0 (or greater)
  of the \pkg{gurobi} package must be installed. The solution pool is
  generated using the default pool search mode of zero
  (see \url{http://www.gurobi.com/documentation/8.0/refman/poolsearchmode.html#parameter:PoolSearchMode}).
}
\examples{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)
\donttest{
# create minimal problem with pool portfolio
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2) \%>\%
      add_pool_portfolio() \%>\%
      add_default_solver(gap = 0.02, verbose = FALSE)

# solve problem
s1 <- solve(p1)

# print number of solutions found
print(length(s1))

# plot solutions
plot(stack(s1), axes = FALSE, box = FALSE)

# build multi-zone conservation problem with pool portfolio
p2 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_binary_decisions() \%>\%
      add_pool_portfolio() \%>\%
      add_default_solver(gap = 0.02, verbose = FALSE)

# solve the problem
s2 <- solve(p2)

# print number of solutions found
print(length(s2))

# print solutions
str(s2, max.level = 1)

# plot solutions in portfolio
plot(stack(lapply(s2, category_layer)), main = "solution", axes = FALSE,
     box = FALSE)
}
}
\seealso{
\code{\link{portfolios}}.
}
