% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_feature_contiguity_constraints.R
\name{add_feature_contiguity_constraints}
\alias{add_feature_contiguity_constraints}
\alias{add_feature_contiguity_constraints,ConservationProblem,ANY,matrix-method}
\alias{add_feature_contiguity_constraints,ConservationProblem,ANY,data.frame-method}
\alias{add_feature_contiguity_constraints,ConservationProblem,ANY,Matrix-method}
\alias{add_feature_contiguity_constraints,ConservationProblem,ANY,ANY-method}
\alias{add_feature_contiguity_constraints}
\alias{add_feature_contiguity_constraints}
\alias{add_feature_contiguity_constraints}
\alias{add_feature_contiguity_constraints}
\title{Add feature contiguity constraints}
\usage{
\S4method{add_feature_contiguity_constraints}{ConservationProblem,ANY,Matrix}(x, zones, data)

\S4method{add_feature_contiguity_constraints}{ConservationProblem,ANY,data.frame}(x, zones, data)

\S4method{add_feature_contiguity_constraints}{ConservationProblem,ANY,matrix}(x, zones, data)

\S4method{add_feature_contiguity_constraints}{ConservationProblem,ANY,ANY}(x, zones, data)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{zones}{\code{matrix}, \code{Matrix} or \code{list} object describing
the connection scheme for different zones. For \code{matrix} or
and \code{Matrix} arguments, each row and column corresponds
to a different zone in the argument to \code{x}, and cell values must
contain binary \code{numeric} values (i.e. one or zero) that indicate
if connected planning units (as specified in the argument to
\code{data}) should be still considered connected if they are allocated to
different zones. The cell values along the diagonal
of the matrix indicate if planning units should be subject to
contiguity constraints when they are allocated to a given zone. Note
arguments to \code{zones} must be symmetric, and that a row or column has
a value of one then the diagonal element for that row or column must also
have a value of one. If the connection scheme between different zones
should differ among the features, then the argument to \code{zones} should
be a \code{list} of \code{matrix} or \code{Matrix} objects that shows the
specific scheme for each feature using the conventions described above.
The default argument to \code{zones} is an identity
matrix (i.e. a matrix with ones along the matrix diagonal and zeros
elsewhere), so that planning units are only considered connected if they
are both allocated to the same zone.}

\item{data}{\code{NULL}, \code{matrix}, \code{Matrix}, \code{data.frame}
or \code{list} of \code{matrix}, \code{Matrix}, or \code{data.frame}
objects. The argument to data shows which planning units should be treated
as being connected when implementing constraints to ensure that features
are represented in contiguous units. If different features have
different dispersal capabilities, then it may be desirable to specify
which sets of planning units should be treated as being connected
for which features using a \code{list} of objects. The default argument
is \code{NULL} which means that the connection data is calculated
automatically using the \code{\link{connected_matrix}} function and so
all adjacent planning units are treated as being connected for all
features. See the Details section for more information.}
}
\description{
Add constraints to a \code{\link{problem}} to ensure that each feature is
represented in a contiguous unit of dispersible habitat. These constraints
are a more advanced version of those implemented in the
\code{\link{add_contiguity_constraints}} function, because they ensure that
each feature is represented in a contiguous unit and not that the entire
solution should form a contiguous unit. Additionally, this function
can use data showing the distribution of dispersible habitat for each
feature to ensure that all features can disperse through out the areas
designated for their conservation.
}
\details{
This function uses connection data to identify solutions that
  represent features in contiguous units of dispersible habitat. In earlier
  versions of the \pkg{prioritizr} package, it was known as the
  \code{add_corridor_constraints} function but has since been renamed for
  clarity. It was inspired by the mathematical formulations detailed in
  {\"O}nal and Briers (2006) and Cardeira \emph{et al.} 2010.
  \strong{Please note that adding these constraints to a problem will
  drastically increase the amount of time required to solve it.}

  The argument to \code{data} can be specified in several ways:

  \describe{

  \item{\code{NULL}}{connection data should be calculated automatically
    using the \code{\link{connected_matrix}} function. This is the default
    argument and means that all adjacent planning units are treated
    as potentially dispersible for all features.
    Note that the connection data must be manually defined
    using one of the other formats below when the planning unit data
    in the argument to \code{x} is not spatially referenced (e.g.
    in \code{data.frame} or \code{numeric} format).}
  \item{\code{matrix}, \code{Matrix}}{where rows and columns represent
    different planning units and the value of each cell indicates if the
    two planning units are connected or not. Cell values should be binary
    \code{numeric} values (i.e. one or zero). Cells that occur along the
    matrix diagonal have no effect on the solution at all because each
    planning unit cannot be a connected with itself. Note that pairs
    of connected planning units are treated as being potentially dispersible
    for all features.}

  \item{\code{data.frame}}{containing the fields (columns)
    \code{"id1"}, \code{"id2"}, and \code{"boundary"}. Here, each row
    denotes the connectivity between two planning units following the
    \emph{Marxan} format. The field \code{boundary} should contain
    binary \code{numeric} values that indicate if the two planning units
    specified in the fields \code{"id1"} and \code{"id2"} are connected
    or not. This data can be used to describe symmetric or
    asymmetric relationships between planning units. By default,
    input data is assumed to be symmetric unless asymmetric data is
    also included (e.g. if data is present for planning units 2 and 3, then
    the same amount of connectivity is expected for planning units 3 and 2,
    unless connectivity data is also provided for planning units 3 and 2).
    Note that pairs of connected planning units are treated as being
    potentially dispersible for all features.}

 \item{\code{list}}{containing \code{matrix}, \code{Matrix}, or
    \code{data.frame} objects showing which planning units
    should be treated as connected for each feature. Each element in the
    \code{list} should correspond to a different feature (specifically,
    a different target in the problem), and should contain a \code{matrix},
    \code{Matrix}, or \code{data.frame} object that follows the conventions
    detailed above.}

  }
}
\examples{
# load data
data(sim_pu_raster, sim_pu_zones_stack, sim_features, sim_features_zones)

# create minimal problem
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.3)

# create problem with contiguity constraints
p2 <- p1 \%>\% add_contiguity_constraints()

# create problem with constraints to represent features in contiguous
# units
p3 <- p1 \%>\% add_feature_contiguity_constraints()

# create problem with constraints to represent features in contiguous
# units that contain highly suitable habitat values
# (specifically in the top 1.5th percentile)
cm4 <- lapply(seq_len(nlayers(sim_features)), function(i) {
  # create connectivity matrix using the i'th feature's habitat data
  m <- connectivity_matrix(sim_pu_raster, sim_features[[i]])
  # convert matrix to TRUE/FALSE values in top 20th percentile
  m <- m > quantile(as.vector(m), 1 - 0.015, names = FALSE)
  # convert matrix from TRUE/FALSE to sparse matrix with 0/1s
  m <- as(m, "dgCMatrix")
  # remove 0s from the sparse matrix
  m <- Matrix::drop0(m)
  # return matrix
  m
})
p4 <- p1 \%>\% add_feature_contiguity_constraints(data = cm4)
\donttest{
# solve problems
s1 <- stack(solve(p1), solve(p2), solve(p3), solve(p4))

# plot solutions
plot(s1,  axes = FALSE, box = FALSE,
     main = c("basic solution", "contiguity constraints",
              "feature contiguity constraints",
              "feature contiguity constraints with data"))
}
# create minimal problem with multiple zones, and limit the solver to
# 30 seconds to obtain solutions in a feasible period of time
p5 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(0.1, ncol = 3, nrow = 5)) \%>\%
      add_default_solver(time_limit = 30) \%>\%
      add_binary_decisions()

# create problem with contiguity constraints that specify that the
# planning units used to conserve each feature in different management
# zones must form separate contiguous units
p6 <- p5 \%>\% add_feature_contiguity_constraints(diag(3))

# create problem with contiguity constraints that specify that the
# planning units used to conserve each feature must form a single
# contiguous unit if the planning units are allocated to zones 1 and 2
# and do not need to form a single contiguous unit if they are allocated
# to zone 3
zm7 <- matrix(0, ncol = 3, nrow = 3)
zm7[seq_len(2), seq_len(2)] <- 1
print(zm7)
p7 <- p5 \%>\% add_feature_contiguity_constraints(zm7)

# create problem with contiguity constraints that specify that all of
# the planning units in all three of the zones must conserve first feature
# in a single contiguous unit but the planning units used to conserve the
# remaining features do not need to be contiguous in any way
zm8 <- lapply(seq_len(number_of_features(sim_features_zones)), function(i)
  matrix(ifelse(i == 1, 1, 0), ncol = 3, nrow = 3))
print(zm8)
p8 <- p5 \%>\% add_feature_contiguity_constraints(zm8)
\donttest{
# solve problems
s2 <- lapply(list(p5, p6, p7, p8), solve)
s2 <- stack(lapply(s2, category_layer))

# plot solutions
plot(s2, main = c("p5", "p6", "p7", "p8"), axes = FALSE, box = FALSE)
}
}
\references{


{\"{O}}nal H and Briers RA (2006) Optimal selection of a connected
reserve network. \emph{Operations Research}, 54: 379--388.

Cardeira JO, Pinto LS, Cabeza M and Gaston KJ (2010) Species specific
connectivity in reserve-network design using graphs.
\emph{Biological Conservation}, 2: 408--415.
}
