% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference-trial.r
\name{preference.trial}
\alias{preference.trial}
\title{Create a Preference Trial}
\usage{
preference.trial(
  pref_ss,
  pref_effect,
  selection_ss,
  selection_effect,
  treatment_ss,
  treatment_effect,
  sigma2,
  pref_prop,
  choice_prop = 0.5,
  stratum_prop = 1,
  alpha = 0.05,
  k = 1
)
}
\arguments{
\item{pref_ss}{the sample size of the preference arm.}

\item{pref_effect}{the effect size of the preference arm (delta_pi).}

\item{selection_ss}{the sample size of the selection arm.}

\item{selection_effect}{the effect size of selection arm (delta_nu).}

\item{treatment_ss}{the sample size of the treatment arm .}

\item{treatment_effect}{the sample size of the treatment arm (delta_tau)}

\item{sigma2}{the variance estimate of the outcome of interest. This 
value should be positive numeric values. If study is stratified, should 
be vector of within-stratum variances with length equal to the number of 
strata in the study.}

\item{pref_prop}{the proportion of patients preferring treatment 1. This
value should be between 0 and 1 (phi).}

\item{choice_prop}{the proportion of patients assigned to choice arm in 
the initial randomization. Should be numeric value between
0 and 1 (default=0.5) (theta).}

\item{stratum_prop}{xi a numeric vector of the proportion of patients in 
each stratum. Length of vector should equal the number of strata in the 
study and sum of vector should be 1. All vector elements should be numeric
values between 0 and 1. Default is 1 (i.e. unstratified design) (xi).}

\item{alpha}{the desired type I error rate (default 0.05).}

\item{k}{the ratio of treatment A to treatment B in the random arm
(default 1)..}
}
\description{
Create a Preference Trial
}
\examples{

# Unstratified single trial.
preference.trial(pref_ss=100, pref_effect=1, selection_ss=100, 
  selection_effect=1, treatment_ss=100, treatment_effect=1,
  sigma2=1, pref_prop=0.6)

# Stratified single trial.
preference.trial(pref_ss=100, pref_effect=1, selection_ss=100,
  selection_effect=1, treatment_ss=100, treatment_effect=1,
  sigma2=list(c(1, 0.8)), pref_prop=list(c(0.6, 0.3)),
  choice_prop=0.5, stratum_prop=list(c(0.3, 0.7)))

# Multiple trials unstratified.
preference.trial(pref_ss=100, pref_effect=seq(0.1, 2, by=0.5), 
  selection_ss=100, selection_effect=1, treatment_ss=100, 
  treatment_effect=1, sigma2=1, pref_prop=0.6)

# Multiple, stratified trials.
preference.trial(pref_ss=100, pref_effect=seq(0.1, 2, by=0.5), 
  selection_ss=100, selection_effect=1, treatment_ss=100, 
  treatment_effect=1, sigma2=list(c(1, 0.8)), pref_prop=list(c(0.6, 0.3)), 
  choice_prop=0.5, stratum_prop=list(c(0.3, 0.7)))

}
\references{
Turner RM, et al. (2014). "Sample Size and Power When Designing
 a Randomized Trial for the Estimation of Treatment, Selection, and
 Preference Effects." \emph{Medical Decision Making}, \strong{34}:711-719.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/24695962}{PubMed})

Cameron B, Esserman D (2016). "Sample Size and Power for a
Stratified Doubly Randomized Preference Design." \emph{Stat Methods Med Res}.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/27872194}{PubMed})
}
