% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{analyze_raw_data}
\alias{analyze_raw_data}
\title{Analysis Function: Raw Data}
\usage{
analyze_raw_data(x1, x2, y1, y2, s11 = 1, s22 = 1, s1 = 1, s2 = 1,
  xi = 1, nstrata = 1)
}
\arguments{
\item{x1}{vector of responses for patients choosing treatment 1}

\item{x2}{vector of responses for patients choosing treatment 2}

\item{y1}{vector of responses for patients randomized to treatment 1}

\item{y2}{vector of responses for patients randomized to treatment 2.}

\item{s11}{(if study is stratified) vector of stratum membership for 
patients choosing treatment 1. Should be a vector of the same 
length as x1 with the number of unique values equal to the 
number of strata.}

\item{s22}{(if study is stratified) vector of stratum membership for 
patients choosing treatment 2. Should be a vector of the same 
length as x2 with the number of unique values equal to the number
of strata.}

\item{s1}{(if study is stratified) vector of stratum membership for 
patients randomized to treatment 1. Should be a vector of the 
same length as y1 with the number of unique values equal to the 
number of strata.}

\item{s2}{(if study is stratified) vector of stratum membership for patients
randomized to treatment 2. Should be a vector of the same length 
as y2 with the number of unique values equal to the number of 
strata.}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}
}
\description{
Computes the test statistic and p-value for the preference, selection, and 
treatment effects for the two-stage randomized trial using
provided raw data
}
\examples{
#Unstratified
x1<-c(10,8,6,10,5)
x2<-c(8,7,6,10,12,11,6,8)
y1<-c(10,5,7,9,12,6)
y2<-c(8,9,10,7,8,11)
analyze_raw_data(x1,x2,y1,y2)
#Stratified
x1<-c(10,8,6,10,5)
s11<-c(1,1,2,2,2)
x2<-c(8,7,6,10,12,11,6,8)
s22<-c(1,1,1,1,2,2,2,2)
y1<-c(10,5,7,9,12,6)
s1<-c(1,1,1,2,2,2)
y2<-c(8,9,10,7,8,11)
s2<-c(1,1,1,2,2,2)
analyze_raw_data(x1,x2,y1,y2,s11=s11,s22=s22,s1=s1,s2=s2,xi=c(0.5,0.5),nstrata=2)
}
\references{
Rucker G (1989). "A two-stage trial design for testing treatment, 
self-selection and treatment preference effects." \emph{Stat Med}, 
\strong{8}(4):477-485. 
(\href{https://www.ncbi.nlm.nih.gov/pubmed/2727471}{PubMed})

Cameron B, Esserman D (2016). "Sample Size and Power for a 
Stratified Doubly Randomized Preference Design." \emph{Stat Methods Med Res}. 
(\href{https://www.ncbi.nlm.nih.gov/pubmed/27872194}{PubMed})
}
