% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_aux.R
\name{createTPRSmodelmatrix}
\alias{createTPRSmodelmatrix}
\title{Create matrix of Thin-Plate Regression Splines (TPRS)}
\usage{
createTPRSmodelmatrix(data, df = 5, covarnames = NULL, xname = "x",
  yname = "y", TPRSfx = TRUE, matrixonly = TRUE)
}
\arguments{
\item{data}{Matrix or data frame of data}

\item{df}{Degrees of freedom for thinplate splines. This does not include an intercept, so the \code{k} argument of \code{s()} is \eqn{k = df + 1}.}

\item{covarnames}{Names of other covariates to be included in the model
matrix.}

\item{xname}{Name of variable the provides the x-coordinate of location.}

\item{yname}{Name of variable the provides the y-coordinate of location.}

\item{TPRSfx}{Should the TPRS degrees of freedom be fixed. Passed as the \code{fx} argument to \code{s()}.}

\item{matrixonly}{Logical indicator of whether only the model matrix should
be returned, or the full output from \code{\link{gam}}.}
}
\description{
Wrapper function for creating a matrix of thin-plate regression splines (TPRS)
	to be used in a regression analysis.
}
\examples{
n <- 200
x <- runif(n=n, 0, 100)
y <- runif(n=n, 0, 100)
d <- data.frame(x=x, y=y)
mx <- createTPRSmodelmatrix(data=d, df=5)
}
\seealso{
\code{\link{createPCAmodelmatrix}}, \code{\link{predkmeansCVest}}
}
\author{
Joshua Keller
}
