% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{qb_dat2}
\alias{qb_dat2}
\title{Quasi-binomial data (example 2)}
\format{
A \code{data.frame} with 3 rows and 2 columns:
\describe{
  \item{succ}{numbers of success}
  \item{fail}{numbers of failures}
}
}
\usage{
qb_dat2
}
\description{
This data set contains sampled quasi binomial data from 3 clusters with
different size.The data set was sampled with \code{rqbinom(n=3, size=c(40, 50, 60), prob=0.1, phi=3)}.
}
\examples{
# Prediction interval using qb_dat2 as future data
pred_int <- quasi_bin_pi(histdat=qb_dat1, newdat=qb_dat2, nboot=100)
summary(pred_int)

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
