% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{run_test}
\alias{run_test}
\title{Run a test}
\usage{
run_test(
  hook_name,
  file_name = hook_name,
  suffix = ".R",
  std_err = NULL,
  std_out = NULL,
  cmd_args = NULL,
  artifacts = NULL,
  file_transformer = function(files) files,
  env = character(),
  expect_success = is.null(std_err),
  read_only = FALSE
)
}
\arguments{
\item{hook_name}{The name of the hook in \verb{inst/hooks/exported/}, without
file extension.}

\item{file_name}{The file to test in \verb{tests/in} (without extension). Can be
a named vector of length one where the name is the target location relative
to the temporary location and the value is the source of the file.}

\item{suffix}{The suffix of \code{file_name}.}

\item{std_err}{An expected error message. If no error is expected, this
can be \code{NULL}. In that case, the \code{comparator} is applied.}

\item{std_out}{The expected stdout message. If \code{NULL}, this check is omitted.}

\item{cmd_args}{More arguments passed to the file. Pre-commit handles it as
described \href{https://pre-commit.com/#arguments-pattern-in-hooks}{here}.}

\item{artifacts}{Path with artifact files to copy to the temp directory root where
the test is run. If you don't target the root, this can be a named vector
of length one where the name is the target location relative to the
temporary location and the value is the source of the file.}

\item{file_transformer}{A function that takes the file names as input and is
ran right before the hook script is invoked, returning the path to the
files, potentially modified (if renamed). This can be useful if you need to
make in-place modifications to the file, e.g. to test hooks that operate on
\code{.Rprofile}. You can't have different names for different tests on that
file because it must be called \code{.Rprofile} all the time. And R CMD check
seems to remove hidden files, so we must also rename it. The transformation
is also applied to a temp copy of the reference file before a comparison is
made.}

\item{env}{The environment variables to set with \code{\link[base:system2]{base::system2()}}.}

\item{expect_success}{Whether or not an exit code 0 is expected. This can
be derived from \code{std_err}, but sometimes, non-empty stderr does not mean
error, but just a message.}

\item{read_only}{If \code{TRUE} and \code{artifacts} are not \code{NULL}, then assert that hook
did not modify the artifacts.}
}
\description{
Tests for the executables used as pre-commit hooks via \code{entrypoint} in
\code{.pre-commit-config.yaml}. Set's the env variable \code{R_PRECOMMIT_HOOK_ENV} to
when running.
}
\details{
Two potential outcomes of a hooks are pass or fail. This is reflected on the
level of the executable: Fail means the executable fails or the file is
changed. Pass means the executable succeeds and the file is unchanged.
We check if the executable passes as follows:
\itemize{
\item If we expect success (by setting \code{std_err} to \code{NULL}), we make sure
nothing was written to sterr and the file content does not change.
\item If we expect failure, it can be due to changed file or due to failed
executable. To check for failed executable, we set \code{std_err} to
the message we expect. To check changed file content, we set \code{std_err} to
\code{NA}.
}
}
\keyword{internal}
