% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.r
\name{ci}
\alias{ci}
\alias{precintcon.ci.analysis}
\title{Concentration Index}
\usage{
ci(\dots, interval = 1)
}
\arguments{
\item{interval}{the interval in millimeters applied for calculating the 
concentration index. (Default value: 1)}

\item{\dots}{a set of daily precipitation series.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{dataset} is the precipitation serie name.
\item \code{a} is the constant of the exponential curve defined via the 
least-squares method.
\item \code{b} is the constant of the exponential curve defined via the 
least-squares method.
\item \code{r2} is the determination of coefficient of determination (R2) of 
the exponential model.
\item \code{A} is the area over the exponential curve.
\item \code{S} is the are compressed for the exponential curve.
\item \code{ci} is the concentration index.
}
}
\description{
Calculates the Concentration Index (CI) on a daily 
precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the Concentration Index Analysis
ci(daily, interval = 1)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{pplot.lorenz}}
\code{\link{read.data}}
\code{\link{as.daily}}
}
\keyword{concentration}
\keyword{index}
\keyword{precipitation}

