% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{pairplot}
\alias{pairplot}
\title{Create partial dependence plot for a pair of predictor variables in a prediction 
rule ensemble (pre)}
\usage{
pairplot(
  object,
  varnames,
  type = "both",
  penalty.par.val = "lambda.1se",
  nvals = c(20L, 20L),
  pred.type = "response",
  ...
)
}
\arguments{
\item{object}{an object of class \code{\link{pre}}}

\item{varnames}{character vector of length two. Currently, pairplots can only
be requested for non-nominal variables. If varnames specifies the name(s) of
variables of class \code{"factor"}, an error will be printed.}

\item{type}{character string. Type of plot to be generated. 
\code{type = "heatmap"} yields a heatmap plot, \code{type = "contour"} yields 
a contour plot, \code{type = "both"} yields a heatmap plot with added contours,
\code{type = "perspective"} yields a three dimensional plot.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{nvals}{optional numeric vector of length 2. For how many values of
x1 and x2 should partial dependence be plotted? If \code{NULL}, all observed
values for the two predictor variables specified will be used (see details).}

\item{pred.type}{character string. Type of prediction to be plotted on z-axis.
\code{pred.type = "response"} gives fitted values for continuous outputs and
fitted probabilities for nominal outputs. \code{pred.type = "link"} gives fitted
values for continuous outputs and linear predictor values for nominal outputs.}

\item{...}{Additional arguments to be passed to \code{\link[graphics]{image}}, 
\code{\link[graphics]{contour}} or \code{\link[graphics]{persp}} (depending on
whether \code{type} is specified to be \code{"heatmap"}, \code{"contour"}, \code{"both"} 
or \code{"perspective"}).}
}
\description{
\code{pairplot} creates a partial dependence plot to assess the effects of a
pair of predictor variables on the predictions of the ensemble. Note that plotting 
partial dependence is computationally intensive. Computation time will increase 
fast with increasing numbers of observations and variables. For large 
datasets, package `plotmo` (Milborrow, 2019) provides more efficient functions 
for plotting partial dependence and also supports `pre` models.
}
\details{
By default, partial dependence will be plotted for each combination
of 20 values of the specified predictor variables. When \code{nvals = NULL} is
specified a dependence plot will be created for every combination of the unique
observed values of the two predictor variables specified. Therefore, using
\code{nvals = NULL} will often result in long computation times, and / or
memory allocation errors. Also, \code{\link{pre}} ensembles derived
from training datasets that are very wide or long may result in long
computation times and / or memory allocation errors. In such cases, reducing
the values supplied to \code{nvals} will reduce computation time and / or
memory allocation errors. When the nvals argument is supplied, values for the
minimum, maximum, and nvals - 2 intermediate values of the predictor variable
will be plotted. Furthermore, if none of the variables specified appears in
the final prediction rule ensemble, an error will occur.

See also section 8.1 of Friedman & Popescu (2008).
}
\note{
Function \code{pairplot} uses package akima to construct interpolated 
surfaces and  has an ACM license that restricts applications to non-commercial 
usage, see 
\url{https://www.acm.org/publications/policies/software-copyright-notice}
Function \code{pairplot} prints a note referring to this ACM licence.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
pairplot(airq.ens, c("Temp", "Wind"))}
}
\references{
Fokkema, M. (2020). Fitting prediction rule ensembles with R 
package pre. \emph{Journal of Statistical Software, 92}(12), 1-30.
\url{https://doi.org/10.18637/jss.v092.i12}

Friedman, J. H., & Popescu, B. E. (2008). Predictive learning 
via rule ensembles. \emph{The Annals of Applied Statistics, 2}(3), 916-954.

Milborrow, S. (2019). plotmo: Plot a model's residuals, response, and partial 
dependence plots. \url{https://CRAN.R-project.org/package=plotmo}
}
\seealso{
\code{\link{pre}}, \code{\link{singleplot}}
}
