% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{plot.pre}
\alias{plot.pre}
\title{Plot method for class pre}
\usage{
\method{plot}{pre}(x, penalty.par.val = "lambda.1se", linear.terms = TRUE,
  nterms = NULL, ask = FALSE, exit.label = "0", standardize = FALSE,
  plot.dim = c(3, 3), ...)
}
\arguments{
\item{x}{an object of class \code{\link{pre}}.}

\item{penalty.par.val}{character. Which value of the penalty parameter
criterion should be used? The value yielding minimum cv error
(\code{"lambda.min"}) or penalty parameter yielding error within 1 standard
error of minimum cv error ("\code{lambda.1se}")? Alternatively, a numeric 
value may be specified, corresponding to one of the values of lambda in the 
sequence used by glmnet, for which estimated cv error can be inspected by 
running \code{x$glmnet.fit} and \code{plot(x$glmnet.fit)}.}

\item{linear.terms}{logical. Should linear terms be included in the plot?}

\item{nterms}{numeric. The total number of terms (or rules, if 
\code{linear.terms = FALSE}) being plotted. Default is \code{NULL}, 
resulting in all terms of the final ensemble to be plotted.}

\item{ask}{logical. Should user be prompted before starting a new page of
plots?}

\item{exit.label}{character string. Label to be printed in nodes to which 
the rule does not apply (``exit nodes'')?}

\item{standardize}{logical. Should printed importances be standardized? See
\code{\link{importance}}.}

\item{plot.dim}{integer vector of length two. Specifies the number of rows
and columns in the plot. The default yields a plot with three rows and three 
columns, depicting nine baselearners per plotting page.}

\item{...}{Arguments to be passed to \code{\link[grid]{gpar}}.}
}
\description{
\code{plot.pre} creates one or more plots depicting the rules in the final
ensemble as simple decision trees.
}
\examples{
\donttest{
 set.seed(42)
 airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
 plot(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{print.pre}}
}
