% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R, R/pre.R
\name{coef.gpe}
\alias{coef.gpe}
\alias{coef.pre}
\title{Coefficients for the final prediction rule ensemble}
\usage{
\method{coef}{gpe}(object, penalty.par.val = "lambda.1se", ...)

\method{coef}{pre}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}}

\item{penalty.par.val}{character. Penalty parameter criterion to be used for 
selecting final model: lambda giving minimum cv error (\code{"lambda.min"}) or 
lambda giving cv error that is within 1 standard error of minimum cv error 
("\code{lambda.1se}"). Alternatively, a numeric value may be specified, 
corresponding to one of the values of lambda in the sequence used by glmnet,
for which estimated cv error can be inspected by running 
\code{object$glmnet.fit} and \code{plot(object$glmnet.fit)}.}

\item{...}{additional arguments to be passed to \code{\link[glmnet]{coef.glmnet}}.}
}
\value{
returns a dataframe with 3 columns: coefficient, rule (rule or 
variable name) and description (\code{NA} for linear terms, conditions for 
rules).
}
\description{
\code{coef.pre} returns coefficients for prediction rules and linear terms in 
the final ensemble
}
\details{
In rare cases, duplucated variable names may appear in the model.
For example, when the first variable is named 'V1' and is a factor, and 
there is a variable called 'V10' and/or 'V11' and/or 'V12' (etc), which 
is/are numeric. For the binary factor V1, dummy contrast variables were 
created to fit the model, called 'V10', 'V11', 'V12' (etc). As should be 
clear from this example, this yields replicated variable names, which may
yield errors or incorrect results. Users should avoid this situation by
renaming the variables prior to the analysis.
}
\examples{
\donttest{
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
coefs <- coef(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{plot.pre}}, 
\code{\link{cvpre}}, \code{\link{importance}}, \code{\link{predict.pre}}, 
\code{\link{interact}}, \code{\link{print.pre}}
}
