% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_posterior.R
\name{calc_posterior}
\alias{calc_posterior}
\title{Calculate a single posterior probability}
\usage{
calc_posterior(
  y,
  n,
  p0,
  direction = "greater",
  delta = NULL,
  prior = c(0.5, 0.5),
  S = 5000
)
}
\arguments{
\item{y}{vector of length two containing total responses c(y0, y1) for
two-sample case; integer of total responses y for one-sample case}

\item{n}{vector of length two containing the sample size so far c(n0, n1)
for two-sample case; integer of sample size so far n for one-sample case}

\item{p0}{The target value to compare to in the one-sample case. Set to NULL
in two-sample case.}

\item{direction}{"greater" (default) if interest is in p(p1 > p0) and "less"
if interest is in p(p1 < p0) for two-sample case. For one-sample case,
"greater" if interest is in p(p > p0) and "less" if interest is in p(p < p0).}

\item{delta}{clinically meaningful difference between groups.
Typically 0 for two-sample case. NULL for one-sample case (default).}

\item{prior}{hyperparameters of prior beta distribution.
Beta(0.5, 0.5) is default}

\item{S}{number of samples, default is 5000}
}
\value{
Returns the posterior probability of interest
}
\description{
This function is meant to be used in the context of a
clinical trial with a binary endpoint. For the two-sample case, the total
number of events in the standard-of-care arm is y0 and the total number of
events in the experimental arm is y1. The function samples from the posterior
beta distribution based on the data and the prior beta hyperparameters, and
returns the posterior probability that p1 is greater than (or less than) p0
given the data. The one-sample case is also available, in which a target p0
must be specified and the function returns the posterior probability that
p is greater than (or less than) p0 given the data.
}
\examples{

set.seed(123)

# Two-sample case
calc_posterior(y = c(14, 23), n = c(100, 100), p0 = NULL, delta = 0)

# One-sample case
calc_posterior(y = 27, n = 100, p0 = 0.2)

}
