% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_vietnam.R
\docType{data}
\name{ppiVNM2023}
\alias{ppiVNM2023}
\title{Poverty Probability Index (PPI) lookup table for Vietnam for 2023}
\format{
A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile60}}{Below 60th percentile poverty line}
\item{\code{percentile80}}{Below 80th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiVNM2023
}
\description{
Poverty Probability Index (PPI) lookup table for Vietnam for 2023
}
\examples{
  # Access Vietnam PPI table
  ppiVNM2023

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiVNM2023[ppiVNM2023$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiVNM2023, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiVNM2023[ppiVNM2023$score == ppiScore, "percentile20"]

}
\keyword{datasets}
