% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_query_string.R
\name{build_query_string}
\alias{build_query_string}
\title{build_query_string
Create simplified povcalnet query string}
\usage{
build_query_string(
  country,
  povline,
  year,
  aggregate = FALSE,
  fill_gaps = FALSE,
  coverage = "all",
  ppp = NULL,
  format = "json"
)
}
\arguments{
\item{country}{character: list of country iso3 code (accepts multiple) or `all`. Use \href{https://www.iban.com/country-codes}{iso3 codes }}

\item{povline}{numeric: poverty line (in 2011 PPP-adjusted USD) to calculate poverty measures}

\item{year}{numeric:  list of years, or `all`, or `last`.}

\item{aggregate}{logical: `TRUE` will return aggregate results,
`FALSE` country-level results.}

\item{fill_gaps}{logical: `TRUE` will interpolate / extrapolate values when
surveys are not available for a specific year.}

\item{coverage}{character: Can take one of four values: `all` (default), `national`, `urban`, `rural`.}

\item{ppp}{numeric: Optional - Allows the selection of custom PPP (Purchasing Power Parity) exchange rates}

\item{format}{character: Response format to be requested from the API:
`csv` or `json`}
}
\value{
character
}
\description{
build_query_string
Create simplified povcalnet query string
}
\examples{

build_query_string(country = c("ALB", "CHN"),
povline = 1.9,
year = c(2002, 2012))
}
