% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-functions.R
\name{check_no_overlap_colnums}
\alias{check_no_overlap_colnums}
\title{Check that Colnum Vectors do not Overlap}
\usage{
check_no_overlap_colnums(x)
}
\arguments{
\item{x}{A named list of integer vectors.}
}
\value{
\code{TRUE}, invisibly
}
\description{
Given a named list of colnum vectors, like those
produced by \code{\link[tidyselect:eval_select]{tidyselect::eval_select()}},
throw an error if there is an overlap.
}
\examples{
x <- list(arg1 = c(age = 1L),
          arg2 = c(gender = 4L, region = 5L))
check_no_overlap_colnums(x)
}
\seealso{
\code{\link[tidyselect:eval_select]{tidyselect::eval_select()}}
}
