## ----echo=FALSE, warning=FALSE-------------------------------------------
knitr::opts_knit$set(out.format = "latex")
thm <- knitr::knit_theme$get("acid")
knitr::knit_theme$set(thm)
knitr::opts_chunk$set(concordance=TRUE)
knitr::opts_chunk$set(size = 'footnotesize', message = FALSE, warning = FALSE)
knitr::opts_chunk$set(out.width = '0.5\\linewidth', fig.align = "center", fig.show = 'asis')

## ----poppr_funk, eval = TRUE, echo = FALSE-------------------------------
print_command <- function(funk){
  fargs <- formals(funk)
  
  lapply(names(fargs), function(arg_name, fargs){
    arg <- fargs[[arg_name]]
    if (missing(arg)){
      fargs[[arg_name]] <<- as.symbol(arg_name)
      names(fargs)[names(fargs) == arg_name] <<- ""
    }
  }, fargs)
  fargs$call <- as.symbol(funk)
  fargs <- fargs[c(length(fargs), 1:(length(fargs) - 1))]
  return(as.call(fargs))
}

## ----popprcite, eval = FALSE, size="normalsize"--------------------------
#  citation(package = "poppr")

## ----install, eval=FALSE-------------------------------------------------
#  install.packages("poppr", dependencies=TRUE)

## ----install_depend, eval=FALSE------------------------------------------
#  install.packages(c("adegenet", "pegas", "vegan", "ggplot2", "phangorn", "ape", "igraph"))

## ----install_source, eval=FALSE------------------------------------------
#  install.packages("/path/to/poppr.tar.gz", type="source", repos=NULL)

## ----install_devtools, eval = FALSE--------------------------------------
#  install.packages("devtools")

## ----install_github, eval = FALSE----------------------------------------
#  library("devtools")
#  install_github(repo = "grunwaldlab/poppr")

## ----install_devel, eval = FALSE-----------------------------------------
#  library("devtools")
#  install_github(repo = "grunwaldlab/poppr", ref = "devel")

## ----echo=FALSE----------------------------------------------------------
library("poppr")
x <- list(files="/path/to/R/poppr/files/rootrot.csv", path="/path/to/R/poppr/files")

## ----getfilefunk, eval=FALSE---------------------------------------------
#  library("poppr")

## ----getfilefunk2, eval=FALSE--------------------------------------------
#  x <- getfile()

## ----getfilex------------------------------------------------------------
x

## ----firstpoppr, eval=FALSE----------------------------------------------
#  popdata <- poppr(x$files)

## ----aflp, echo=FALSE-------------------------------------------------------------------
options(width=90)
popprsoutput <- poppr(system.file("files/rootrot.csv", package="poppr"))

## ----firstpoppr2, eval=FALSE------------------------------------------------------------
#  popdata

## ----aflp2, echo=FALSE------------------------------------------------------------------
popprsoutput

## ----getfile_command, echo = FALSE, comment = NA, size = 'normalsize'-------------------
funk <- "getfile"
print_command(funk)

## ----multi_getfile, eval = FALSE--------------------------------------------------------
#  x <- getfile(multi=TRUE)

## ----show_multi_getfile1,eval=FALSE-----------------------------------------------------
#  x

## ----show_multi_getfile,echo=FALSE------------------------------------------------------
x$files <- list.files(dirname(system.file("files/rootrot.csv", package="poppr")))
x$files <- paste(x$path, x$files, sep="/")
x

## ----poppr.all, eval=FALSE--------------------------------------------------------------
#  all_files <- poppr.all(x$files)
#  print(all_files, digits = 2)

## ----poppr.all_eval, echo=FALSE---------------------------------------------------------
print(poppr.all(c(system.file("files/rootrot.csv", package="poppr"), 
                  system.file("files/rootrot2.csv", package="poppr"), 
                  system.file("files/simulated.dat", package="poppr"))), 
      digits = 2)

## ----getfile_adegenet, eval=FALSE-------------------------------------------------------
#  getfile(multi=TRUE)

## ----list_adegenet_files, echo=FALSE----------------------------------------------------
nancylist <- dir(dirname(system.file("files/nancycats.gtx",package="adegenet")))
list(
  files = paste("/path/to/R/adegenet/files", nancylist, sep="/"),
  path = "/path/to/R/adegenet/files"
)

## ----getfile_nancy,eval=FALSE-----------------------------------------------------------
#  getfile(multi=TRUE, pattern="nancy")

## ----show_getfile_nancy, echo=FALSE-----------------------------------------------------
nancylist <- list.files(dirname(system.file("files/nancycats.gtx",package="adegenet")), pattern="nancy")
list(
  files = paste("/path/to/R/adegenet/files", nancylist, sep="/"),
  path = "/path/to/R/adegenet/files"
)

## ----getfile_gtx, eval=FALSE------------------------------------------------------------
#  getfile(multi=TRUE, pattern="gtx")

## ----show_getfile_gtx, echo=FALSE-------------------------------------------------------
nancylist <- list.files(dirname(system.file("files/nancycats.gtx",package="adegenet")), pattern="gtx")
list(
  files = paste("/path/to/R/adegenet/files", nancylist, sep="/"),
  path = "/path/to/R/adegenet/files"
)

## ----getfile_dat, eval=FALSE------------------------------------------------------------
#  getfile(multi=TRUE, pattern="dat")

## ----show_getfile_dat, echo=FALSE-------------------------------------------------------
nancylist <- list.files(dirname(system.file("files/nancycats.gtx",package="adegenet")), pattern="dat")
list(
  files = paste("/path/to/R/adegenet/files", nancylist, sep="/"),
  path = "/path/to/R/adegenet/files"
)

## ----getfile_datend, eval=FALSE---------------------------------------------------------
#  getfile(multi=TRUE, pattern="dat$")

## ----show_getfile_datend, echo=FALSE----------------------------------------------------
nancylist <- list.files(dirname(system.file("files/nancycats.gtx",package="adegenet")), pattern="dat$")
list(
  files = paste("/path/to/R/adegenet/files", nancylist, sep="/"),
  path = "/path/to/R/adegenet/files"
)

## ----microsave, eval=FALSE--------------------------------------------------------------
#  library("poppr")
#  data(microbov)
#  microbov <- as.genclone(microbov)
#  sethierarchy(microbov) <- data.frame(other(microbov))
#  setpop(microbov) <- ~coun/breed/spe
#  genind2genalex(microbov, file="~/Desktop/microbov.csv")

## ----microsave_message, echo=FALSE------------------------------------------------------
cat("Extracting the table ... Writing the table to ~/Desktop/microbov.csv ... Done.")

## ----read.genalex_command, echo = FALSE, comment = NA, size = 'normalsize'--------------
funk <- "read.genalex"
print_command(funk)

## ----system_file_genalex, eval=FALSE----------------------------------------------------
#  system.file("files/rootrot.csv", package="poppr")

## ----system_file_echo, echo=FALSE-------------------------------------------------------
paste("/path/to/R/library/poppr/files/rootrot.csv")

## ----read.genalex_ex--------------------------------------------------------------------
rootrot <- read.genalex(system.file("files/rootrot.csv", package="poppr"))

## ----read.genalex_ex2-------------------------------------------------------------------
rootrot

## ----genind2genalex_command, echo = FALSE, comment = NA, size = 'normalsize'------------
funk <- "genind2genalex"
print_command(funk)

## ----genind2genalex, eval=FALSE---------------------------------------------------------
#  genind2genalex(rootrot, "~/Desktop/rootrot.csv")

## ----genind2genalex_cat, echo=FALSE-----------------------------------------------------
cat("Extracting the table ... Writing the table to ~/Desktop/rootrot.csv ... Done.\n")

## ----nancyxy----------------------------------------------------------------------------
data(nancycats)
nancycats@other$xy

## ----genind2genalex_nancy, eval=FALSE---------------------------------------------------
#  genind2genalex(nancycats, "~/Desktop/nancycats_pop_xy.csv", geo = TRUE)

## ----genind2genalex_cat2, echo=FALSE----------------------------------------------------
cat("Extracting the table ... Writing the table to ~/Desktop/nancycats_pop_xy.csv ... Done.\n")

## ----nancy_grow_xy----------------------------------------------------------------------
nan2 <- nancycats
nan2@other$xy <- nan2@other$xy[rep(1:17, table(pop(nan2))), ]
head(nan2@other$xy)

## ----genind2genalex_nancy_grow, eval=FALSE----------------------------------------------
#  genind2genalex(nan2, "~/Desktop/nancycats_inds_xy.csv", geo = TRUE)

## ----genind2genalex_cat3, echo=FALSE----------------------------------------------------
cat("Extracting the table ... Writing the table to ~/Desktop/nancycats_inds_xy.csv ... Done.\n")

## ----ex_data_picture, echo = FALSE, fig.width=14, fig.height=4, out.width="7in", out.height = "2in"----
library("adegenet")
df <- data.frame(list(locus1=c("101/101", "102/103", "102/102"), 
                      locus2=c("201/201", "202/203", "203/204"), 
                      locus3=c("301/302", "301/303", "304/305")))
dat <- df2genind(df, sep="/")$tab
tdat <- dat
tdat[] <- 1
x <- barplot(tdat, axes = FALSE, axisnames = FALSE)
barplot(rep(3, 12), col = rep(rainbow(3, alpha = 0.5), 3:5), axes = FALSE, add = TRUE)
axis(2, at = 1:3 - 0.5, labels = 1:3, tick = FALSE)
axis(3, at = x, labels = colnames(tdat), tick = FALSE)
axis(1, at = c(2, 6.125, 11.5), labels = names(df), tick = FALSE)

## ----ex_genind, echo=FALSE--------------------------------------------------------------
dat

## ----other_replen-----------------------------------------------------------------------
data(nancycats) # Load the data
other(nancycats) # geographical coordinates
repeats <- rep(2, nLoc(nancycats)) #nLoc = number of loci
repeats
other(nancycats)$repeat_lengths <- repeats
other(nancycats) # two items named xy and repeat_lengths

## ----as.genclone_command, echo = FALSE, comment = NA, size = 'normalsize'---------------
funk <- "as.genclone"
print_command(funk)

## ----show_genind------------------------------------------------------------------------
library("poppr")
data(Aeut)
Aeut

## ----as_genclone------------------------------------------------------------------------
agc <- as.genclone(Aeut)
agc

# We can also manually set the hierarchy.
as.genclone(Aeut, hierarchy = other(Aeut)$population_hierarchy[-1])

## ----genclone_compare-------------------------------------------------------------------
c(is.genind(Aeut), is.genclone(Aeut), is.genind(agc), is.genclone(agc))

# Adegenet functions work the same, too
c(nInd(Aeut), nInd(agc))

## ----setpop-----------------------------------------------------------------------------
# We'll look at the population names
Aeut$pop.names

# genind way:
# Extract the combined hierarchical levels.
pophier <- other(Aeut)$population_hierarchy$Pop_Subpop
pop(Aeut) <- pophier
Aeut$pop.names

# genclone way:
agc
setpop(agc) <- ~Pop/Subpop
agc

# Notice that you only see the first and last three population names.
# Use the print function to display all population names.

print(agc)

## ----formuladef, eval = FALSE-----------------------------------------------------------
#  hier = ~Population/Subpopulation/Year

## ----pinf_show--------------------------------------------------------------------------
data(Pinf)
Pinf
tail(truenames(Pinf[loc = c("L09", "L10")])$tab)

## ----pinf_show_df-----------------------------------------------------------------------
Pinfdf <- genind2df(Pinf, sep = "/")
tail(Pinfdf[10:11])

## ----pinf_recode------------------------------------------------------------------------
Pinf_rc <- recode_polyploids(Pinf, newploidy = 2)
tail(truenames(Pinf_rc[loc = c("L09", "L10")])$tab)

## ----pinf_recode_df---------------------------------------------------------------------
Pinfrcdf <- genind2df(Pinf_rc, sep = "/")
tail(Pinfrcdf[10:11])

## ----aphan_dummy_figshare, eval = FALSE-------------------------------------------------
#  aphan <- read.genalex("http://files.figshare.com/1314228/rootrot.csv")
#  aphan

## ----aphan_figshare, echo = FALSE-------------------------------------------------------
aphan <- namehierarchy(sethierarchy(agc, gethierarchy(agc, ~Pop_Subpop)), ~Pop)
aphan

## ----aphan_split------------------------------------------------------------------------
splithierarchy(aphan) <- ~field/sample
aphan

## ----H3N2_data_show, eval = FALSE-------------------------------------------------------
#  data(H3N2)
#  write.table(other(H3N2)$x, file = "~/Desktop/virus_info.csv", row.names = FALSE)

## ----H3N2_data_noshow, echo = FALSE-----------------------------------------------------
data(H3N2)
virus_info <- as.data.frame(other(H3N2)$x) # extracting the data frame

## ----H3N2_read_table, eval = FALSE------------------------------------------------------
#  virus_info <- read.table("~/Desktop/virus_info.csv", header = TRUE)
#  names(virus_info)

## ----H3N2_read_table_eval, echo = FALSE-------------------------------------------------
names(virus_info)

## ----H3N2_sethierarchy------------------------------------------------------------------
virus <- as.genclone(H3N2) # Converting it to a genclone object.
sethierarchy(virus) <- virus_info # Setting the hierarchy
virus

## ----H3N2_sethierarchy_again------------------------------------------------------------
sethierarchy(virus) <- virus_info[c("country", "year")]
virus

## ----H3N2_set_country-------------------------------------------------------------------
setpop(virus) <- ~year/country
virus

## ----gethierarchy_command, echo = FALSE, comment = NA, size = 'normalsize'--------------
funk <- "gethierarchy"
print_command(funk)

## ----aphan_hier_get---------------------------------------------------------------------
head(gethierarchy(aphan))
head(gethierarchy(aphan, ~field/sample))

## ----virus_get--------------------------------------------------------------------------
head(gethierarchy(virus, ~year/country))
head(gethierarchy(virus, ~year/country, combine = FALSE))

## ----virus_onepop-----------------------------------------------------------------------
head(gethierarchy(virus, ~country))

## ----virus_stupid-----------------------------------------------------------------------
virus_info <- virus_info[["month"]]
names(virus_info)

## ----addhierarchy_command, echo = FALSE, comment = NA, size = 'normalsize'--------------
funk <- "addhierarchy"
print_command(funk)

## ----virus_add_arg----------------------------------------------------------------------
addhierarchy(virus) <- virus_info 
virus

## ----virus_name-------------------------------------------------------------------------
namehierarchy(virus) <- ~country/year/month
virus

## ----virus_add_df, eval = FALSE---------------------------------------------------------
#  addhierarchy(virus) <- data.frame(month = virus_info)

## ----Pinf_setpop------------------------------------------------------------------------
data(Pinf)
Pinf

## ----Pinf_setpop2-----------------------------------------------------------------------
setpop(Pinf) <- ~Country
Pinf # Now set by country

## ----Pinf_setpop_combine----------------------------------------------------------------
setpop(Pinf) <- ~Continent/Country
Pinf

## ----missingo_command, echo = FALSE, comment = NA, size = 'normalsize'------------------
funk <- "missingno"
print_command(funk)

## ----initializing_poppr, out.width=".8\\linewidth", fig.height = 6, fig.width = 10------
library("poppr")
data(nancycats)
info_table(nancycats, plot = TRUE)

## ----nancy_indiv------------------------------------------------------------------------
nancycats$tab[1:5, 8:13]

## ----missingno_replace------------------------------------------------------------------
nanzero <- missingno(nancycats, type = "zero")
nanmean <- missingno(nancycats, type = "mean")
nanzero$tab[1:5, 8:13]
nanmean$tab[1:5, 8:13]

## ----missingno_exclude------------------------------------------------------------------
nanloci <-  missingno(nancycats, "loci")
nangeno <-  missingno(nancycats, "geno")
nanloci$tab[1:5, 8:13]

## ----missingno_loci---------------------------------------------------------------------
nInd(nanloci) # Individuals
locNames(nanloci) # Names of the loci

## ----missingno_geno---------------------------------------------------------------------
nangeno$tab[1:5, 8:13]
nInd(nangeno) # Individuals
locNames(nangeno) # Names of the loci

## ----popsub_command, echo = FALSE, comment = NA, size = 'normalsize'--------------------
funk <- "popsub"
print_command(funk)

## ----popsub_sublist---------------------------------------------------------------------
setpop(virus) <- ~country
virus$pop.names # Only two countries from North America.
vna <- popsub(virus, sublist=c("USA", "Canada"))
vna$pop.names

## ----popsub_sizes-----------------------------------------------------------------------
c(NorthAmerica = nInd(vna), Total = nInd(virus))

## ----popsub_blacklist-------------------------------------------------------------------
vnaminus <- popsub(virus, blacklist=c("USA", "Canada"))
vnaminus$pop.names

## ----length_test------------------------------------------------------------------------
(nInd(vnaminus) + nInd(vna)) == nInd(virus)

## ----popsub_combine---------------------------------------------------------------------
vsort <- sort(virus$pop.names)[1:10]
vsort
valph <- popsub(virus, sublist=vsort, blacklist=c("USA", "Canada"))
valph$pop.names

## ----clonecorrect_command, echo = FALSE, comment = NA, size = 'normalsize'--------------
funk <- "clonecorrect"
print_command(funk)

## ----clonecorrect-----------------------------------------------------------------------
aphan # Original object

## ----clonecorrect2----------------------------------------------------------------------
clonecorrect(aphan,  hier = ~field/sample)
# Your turn: Use the same hierarchy and use combine = TRUE and then
# keep = 1:2. Is there any difference?

## ----clonecorrect3----------------------------------------------------------------------
clonecorrect(aphan, hier = ~field)

## ----clonecorrectx----------------------------------------------------------------------
clonecorrect(aphan, hier = NA)

## ----shufflepop_command, echo = FALSE, comment = NA, size = 'normalsize'----------------
funk <- "shufflepop"
print_command(funk)

## ----shuffle_bd-------------------------------------------------------------------------
data(nancycats)
nan1 <- popsub(nancycats, 1)
reps <- rep(2, 9) # Assuming dinucleotide repeats.
observed <- mean(bruvo.dist(nan1, replen = reps))
observed

## ----shuffle_bd_replicate_dummy, eval=FALSE---------------------------------------------
#  set.seed(9999)
#  bd.test <- replicate(999, mean(bruvo.dist(shufflepop(nan1, method = 2), replen = reps)))

## ----shuffle_bd_replicate, echo = FALSE-------------------------------------------------
bd.test <- c(0.383180217978395, 0.415172887731481, 0.395401716820988, 0.36112075617284, 
0.381246383101852, 0.391417100694444, 0.368165268132716, 0.44764419367284, 
0.39599006558642, 0.392292390046296, 0.416001157407407, 0.359629388503086, 
0.375589554398148, 0.405174575617284, 0.409643856095679, 0.391482204861111, 
0.382218123070988, 0.41436149691358, 0.383174189814815, 0.404762249228395, 
0.409695698302469, 0.351765046296296, 0.375487075617284, 0.394843508873457, 
0.403155140817901, 0.395619936342593, 0.35908203125, 0.396396363811728, 
0.387588011188272, 0.375771604938272, 0.374916811342593, 0.371144386574074, 
0.375567853009259, 0.372751494984568, 0.41537181712963, 0.390055941358025, 
0.372065489969136, 0.38319106867284, 0.418766878858025, 0.389811197916667, 
0.391309799382716, 0.380735194830247, 0.392493730709877, 0.407855902777778, 
0.373485725308642, 0.393967013888889, 0.419801311728395, 0.419554157021605, 
0.349768518518519, 0.368592062114198, 0.396170910493827, 0.38164665316358, 
0.397676745756173, 0.359424430941358, 0.390004099151235, 0.375790895061728, 
0.415828751929012, 0.396510898919753, 0.398491753472222, 0.399006558641975, 
0.378590374228395, 0.410376880787037, 0.373421826774691, 0.401580584490741, 
0.388343942901235, 0.389790702160494, 0.406230709876543, 0.410212914737654, 
0.411181037808642, 0.397419945987654, 0.409830729166667, 0.38501880787037, 
0.375995852623457, 0.374977092978395, 0.404217303240741, 0.381970968364198, 
0.427674093364198, 0.421094955632716, 0.392737268518519, 0.372973331404321, 
0.396556712962963, 0.41493537808642, 0.367643229166667, 0.417230902777778, 
0.37703872492284, 0.388992573302469, 0.390311535493827, 0.404422260802469, 
0.325649836033951, 0.382992139274691, 0.396333670910494, 0.385146604938272, 
0.40302734375, 0.369362461419753, 0.40317684220679, 0.400687210648148, 
0.402665653935185, 0.383434606481481, 0.398591820987654, 0.403266059027778, 
0.33031322337963, 0.381671971450617, 0.398115596064815, 0.401163435570988, 
0.416612413194444, 0.403988233024691, 0.421760464891975, 0.425095244984568, 
0.431723813657407, 0.401032021604938, 0.390247636959877, 0.431340422453704, 
0.390993923611111, 0.421104600694444, 0.339672550154321, 0.437996720679012, 
0.358885513117284, 0.368224344135802, 0.361101466049383, 0.384192949459877, 
0.410045331790123, 0.368414834104938, 0.340546633873457, 0.341089168595679, 
0.387595244984568, 0.371152826003086, 0.386452305169753, 0.438270399305556, 
0.414109519675926, 0.376890432098765, 0.367886766975309, 0.326484133873457, 
0.385950761959877, 0.429093123070988, 0.414934172453704, 0.395864679783951, 
0.385291280864198, 0.405513358410494, 0.373255449459877, 0.380583285108025, 
0.371088927469136, 0.367192322530864, 0.39708236882716, 0.337759211033951, 
0.412621768904321, 0.394872444058642, 0.381664737654321, 0.423829330632716, 
0.389819637345679, 0.420828510802469, 0.404482542438272, 0.414830488040123, 
0.383400848765432, 0.389350646219136, 0.38399040316358, 0.378415557484568, 
0.401076630015432, 0.367534722222222, 0.429076244212963, 0.419275655864198, 
0.369282889660494, 0.402340133101852, 0.341787229938272, 0.379204041280864, 
0.386735628858025, 0.446989535108025, 0.402697000385802, 0.433216386959877, 
0.367690248842593, 0.375049430941358, 0.368416039737654, 0.402647569444444, 
0.40395809220679, 0.425563030478395, 0.45283203125, 0.369378134645062, 
0.355145640432099, 0.419715711805556, 0.321680893132716, 0.400511188271605, 
0.399321228780864, 0.408874662422839, 0.380805121527778, 0.357367621527778, 
0.387917148919753, 0.46065055941358, 0.397224633487654, 0.365272955246914, 
0.419821807484568, 0.395893614969136, 0.434101321373457, 0.420037615740741, 
0.344226224922839, 0.380940152391975, 0.364171006944444, 0.419171971450617, 
0.419407069830247, 0.370770640432099, 0.3603515625, 0.408857783564815, 
0.417365933641975, 0.352559558256173, 0.399633487654321, 0.389433834876543, 
0.394340760030864, 0.383954234182099, 0.388071469907407, 0.359601658950617, 
0.363640528549383, 0.357619598765432, 0.37666015625, 0.39146412037037, 
0.360531201774691, 0.37396556712963, 0.396057581018519, 0.436072530864198, 
0.426344280478395, 0.404943094135802, 0.418567949459877, 0.360329861111111, 
0.44258415316358, 0.382421875, 0.396319203317901, 0.404704378858025, 
0.352875434027778, 0.401589023919753, 0.389913676697531, 0.38095100308642, 
0.390802228009259, 0.401812065972222, 0.410579427083333, 0.401623987268519, 
0.437044270833333, 0.403096064814815, 0.335836226851852, 0.393484760802469, 
0.39955150462963, 0.391191647376543, 0.347428385416667, 0.397435619212963, 
0.372844328703704, 0.405638744212963, 0.381063126929012, 0.377789834104938, 
0.406129436728395, 0.385578221450617, 0.371550684799383, 0.397008825231481, 
0.410454041280864, 0.383675733024691, 0.344425154320988, 0.352178578317901, 
0.395658516589506, 0.410639708719136, 0.372582706404321, 0.401175491898148, 
0.364237316743827, 0.401288821373457, 0.393103780864198, 0.371531394675926, 
0.369349199459877, 0.386342592592593, 0.43155502507716, 0.420232928240741, 
0.448606288580247, 0.345263069058642, 0.399540653935185, 0.376935040509259, 
0.357755835262346, 0.382535204475309, 0.408638358410494, 0.421451822916667, 
0.408481626157407, 0.416130160108025, 0.429947916666667, 0.387145543981481, 
0.427443817515432, 0.334611304012346, 0.389210792824074, 0.370070167824074, 
0.408222415123457, 0.400714940200617, 0.429736930941358, 0.365889033564815, 
0.416772762345679, 0.364687017746914, 0.407233796296296, 0.403978587962963, 
0.371117862654321, 0.43031322337963, 0.368804253472222, 0.376974826388889, 
0.432552083333333, 0.400812596450617, 0.379140142746914, 0.397846739969136, 
0.346225163966049, 0.372135416666667, 0.408092206790123, 0.414579716435185, 
0.404601900077161, 0.40112003279321, 0.364250578703704, 0.359230324074074, 
0.390632233796296, 0.392872299382716, 0.406500771604938, 0.396532600308642, 
0.433258584104938, 0.407444782021605, 0.369508342978395, 0.375815007716049, 
0.404651331018519, 0.398518277391975, 0.403392650462963, 0.393666811342593, 
0.407813705632716, 0.424363425925926, 0.389061294367284, 0.369866415895062, 
0.396776138117284, 0.409172453703704, 0.416928288966049, 0.378232301311728, 
0.40765697337963, 0.417314091435185, 0.389046826774691, 0.415744357638889, 
0.393634259259259, 0.36586612654321, 0.401743344907407, 0.426003086419753, 
0.39360050154321, 0.412666377314815, 0.41353443287037, 0.395747733410494, 
0.390230758101852, 0.386709104938272, 0.387943672839506, 0.35624397183642, 
0.415022183641975, 0.409261670524691, 0.396379484953704, 0.38554084683642, 
0.363905767746914, 0.397246334876543, 0.396917197145062, 0.370558449074074, 
0.326807243441358, 0.380318045910494, 0.371108217592593, 0.402881462191358, 
0.421170910493827, 0.377513744212963, 0.406248794367284, 0.432503858024691, 
0.389230082947531, 0.374774546682099, 0.385296103395062, 0.356553819444444, 
0.429593460648148, 0.399232011959877, 0.413334297839506, 0.357564139660494, 
0.380099826388889, 0.392191116898148, 0.425604021990741, 0.382099971064815, 
0.396692949459877, 0.378401089891975, 0.382632860725309, 0.379443962191358, 
0.353100887345679, 0.350179639274691, 0.400798128858025, 0.391773967978395, 
0.390212673611111, 0.421403597608025, 0.383235677083333, 0.404604311342593, 
0.382499035493827, 0.404053337191358, 0.380803915895062, 0.409326774691358, 
0.360821759259259, 0.352030285493827, 0.382887249228395, 0.362068383487654, 
0.395824893904321, 0.426868730709877, 0.350993441358025, 0.351259886188272, 
0.376520302854938, 0.405735194830247, 0.333004195601852, 0.375434027777778, 
0.454225742669753, 0.385618007330247, 0.397746672453704, 0.399845679012346, 
0.381020929783951, 0.390805844907407, 0.37349537037037, 0.366712480709877, 
0.34423828125, 0.384405140817901, 0.376293643904321, 0.423095100308642, 
0.362887008101852, 0.410147810570988, 0.407542438271605, 0.397905815972222, 
0.438437982253086, 0.391622058256173, 0.359475067515432, 0.412031008873457, 
0.395044849537037, 0.406966145833333, 0.377733169367284, 0.353202160493827, 
0.382794415509259, 0.39121696566358, 0.411637972608025, 0.406511622299383, 
0.395616319444444, 0.352868200231481, 0.411424575617284, 0.386510175540123, 
0.388442804783951, 0.381898630401235, 0.44444565007716, 0.414210792824074, 
0.415461033950617, 0.43555290316358, 0.386957465277778, 0.349611786265432, 
0.360434751157407, 0.417320119598765, 0.381280140817901, 0.383104263117284, 
0.404839409722222, 0.363233024691358, 0.379905719521605, 0.405243296682099, 
0.364553192515432, 0.345275125385802, 0.414390432098765, 0.405825617283951, 
0.371305941358025, 0.382529176311728, 0.404598283179012, 0.369455295138889, 
0.409336419753086, 0.394952015817901, 0.380199893904321, 0.405327690972222, 
0.405947386188272, 0.384239969135802, 0.40400390625, 0.397398244598765, 
0.386231674382716, 0.398750964506173, 0.366917438271605, 0.413671875, 
0.377615017361111, 0.441937934027778, 0.373066165123457, 0.426989293981481, 
0.393100163966049, 0.384252025462963, 0.386873070987654, 0.447501929012346, 
0.392793933256173, 0.350059076003086, 0.350538917824074, 0.375974151234568, 
0.394501109182099, 0.364362702546296, 0.359079619984568, 0.398760609567901, 
0.365193383487654, 0.413980516975309, 0.336530671296296, 0.367936197916667, 
0.427888695987654, 0.411747685185185, 0.361118344907407, 0.340543016975309, 
0.374469521604938, 0.376176697530864, 0.339312065972222, 0.36255184220679, 
0.428757957175926, 0.396603732638889, 0.398220486111111, 0.377998408564815, 
0.458297164351852, 0.411371527777778, 0.388263165509259, 0.38179012345679, 
0.393031442901235, 0.378683207947531, 0.365017361111111, 0.395235339506173, 
0.361461950231481, 0.387102141203704, 0.446594087577161, 0.402951388888889, 
0.413870804398148, 0.383012635030864, 0.392099488811728, 0.380672501929012, 
0.369762731481481, 0.404457224151235, 0.437080439814815, 0.42606819058642, 
0.344309413580247, 0.370612702546296, 0.386519820601852, 0.330557966820988, 
0.414650848765432, 0.376538387345679, 0.367432243441358, 0.434569106867284, 
0.410765094521605, 0.393921199845679, 0.430010609567901, 0.424990354938272, 
0.37861930941358, 0.389408516589506, 0.397084780092593, 0.418393132716049, 
0.404865933641975, 0.419696421682099, 0.42328197337963, 0.35384837962963, 
0.440784143518519, 0.339085407021605, 0.398503809799383, 0.38325496720679, 
0.343084490740741, 0.365447771990741, 0.394507137345679, 0.437507233796296, 
0.373072193287037, 0.383201919367284, 0.399937307098765, 0.379497010030864, 
0.356886574074074, 0.420395688657407, 0.356246383101852, 0.388859953703704, 
0.445442708333333, 0.361277488425926, 0.371222752700617, 0.388386140046296, 
0.385187596450617, 0.375283323688272, 0.387521701388889, 0.388689959490741, 
0.357333863811728, 0.453578317901235, 0.36547550154321, 0.39613956404321, 
0.417972366898148, 0.374092158564815, 0.382782359182099, 0.381862461419753, 
0.423981240354938, 0.414672550154321, 0.348871527777778, 0.387929205246914, 
0.413448832947531, 0.389042004243827, 0.336711516203704, 0.407901716820988, 
0.370625964506173, 0.412831548996914, 0.381561053240741, 0.366015625, 
0.37412712191358, 0.407411024305556, 0.378071952160494, 0.372794897762346, 
0.419258777006173, 0.402212336033951, 0.403891782407407, 0.425675154320988, 
0.415992717978395, 0.392179060570988, 0.407238618827161, 0.402026668595679, 
0.395384837962963, 0.380525414737654, 0.363785204475309, 0.412713396990741, 
0.398572530864198, 0.395569299768519, 0.383186246141975, 0.36587215470679, 
0.36796272183642, 0.365980661651235, 0.357057773919753, 0.41279899691358, 
0.395349874614198, 0.390680459104938, 0.377873022762346, 0.389040798611111, 
0.377109857253086, 0.348837770061728, 0.368975453317901, 0.357876398533951, 
0.374716676311728, 0.394544511959877, 0.394398630401235, 0.417626350308642, 
0.382323013117284, 0.351409384645062, 0.425944010416667, 0.388559751157407, 
0.428446903935185, 0.398743730709877, 0.392685426311728, 0.398725646219136, 
0.345968364197531, 0.377530623070988, 0.382658179012346, 0.349848090277778, 
0.396012972608025, 0.353338396990741, 0.430840084876543, 0.377238859953704, 
0.394731385030864, 0.411692226080247, 0.37016300154321, 0.399468315972222, 
0.453606047453704, 0.368296682098765, 0.33921802662037, 0.417118778935185, 
0.406395881558642, 0.389037181712963, 0.417344232253086, 0.374247685185185, 
0.358676938657407, 0.404021990740741, 0.412682050540123, 0.347416329089506, 
0.394303385416667, 0.333446662808642, 0.361119550540123, 0.397492283950617, 
0.450394241898148, 0.381412760416667, 0.429846643518519, 0.376713204089506, 
0.40488884066358, 0.372957658179012, 0.404951533564815, 0.3615234375, 
0.380840084876543, 0.375343605324074, 0.378115354938272, 0.386223234953704, 
0.407086709104938, 0.390598476080247, 0.38189380787037, 0.426994116512346, 
0.398075810185185, 0.355055217978395, 0.40372299382716, 0.384253231095679, 
0.377801890432099, 0.421995563271605, 0.438786410108025, 0.39292896412037, 
0.373168643904321, 0.396023823302469, 0.406528501157407, 0.385123697916667, 
0.411454716435185, 0.407146990740741, 0.354187162422839, 0.385707224151235, 
0.45199893904321, 0.423301263503086, 0.426093508873457, 0.357736545138889, 
0.41849681712963, 0.397376543209877, 0.388570601851852, 0.369656635802469, 
0.389693045910494, 0.364955873842593, 0.41753833912037, 0.381816647376543, 
0.366625675154321, 0.405238474151235, 0.381565875771605, 0.395021942515432, 
0.412459008487654, 0.359935619212963, 0.361991222993827, 0.385581838348765, 
0.415857687114198, 0.383632330246914, 0.434061535493827, 0.352875434027778, 
0.42680362654321, 0.364462770061728, 0.401983265817901, 0.371050347222222, 
0.382638888888889, 0.341284481095679, 0.388495852623457, 0.40468147183642, 
0.398787133487654, 0.434308690200617, 0.415680459104938, 0.407871576003086, 
0.431914303626543, 0.387229938271605, 0.388371672453704, 0.377091772762346, 
0.409389467592593, 0.37120346257716, 0.39843147183642, 0.385562548225309, 
0.366154272762346, 0.373057725694444, 0.399386332947531, 0.357748601466049, 
0.436159336419753, 0.362225115740741, 0.365024594907407, 0.396502459490741, 
0.415729890046296, 0.37396556712963, 0.361053240740741, 0.37051986882716, 
0.409051890432099, 0.406489920910494, 0.399397183641975, 0.346672453703704, 
0.385487798996914, 0.382908950617284, 0.387248022762346, 0.370142505787037, 
0.361493296682099, 0.373767843364198, 0.419709683641975, 0.432388117283951, 
0.345741705246914, 0.386319685570988, 0.368377459490741, 0.377933304398148, 
0.355714699074074, 0.379832175925926, 0.376674623842593, 0.352170138888889, 
0.402731963734568, 0.35858772183642, 0.409573929398148, 0.430726755401235, 
0.398097511574074, 0.387141927083333, 0.401740933641975, 0.397419945987654, 
0.374105420524691, 0.405016637731481, 0.382298900462963, 0.392015094521605, 
0.342367139274691, 0.41382137345679, 0.36112075617284, 0.39140625, 
0.391415895061728, 0.362373408564815, 0.418616174768519, 0.385100790895062, 
0.37310474537037, 0.359172453703704, 0.344196084104938, 0.405438609182099, 
0.393285831404321, 0.426271942515432, 0.407395351080247, 0.358265817901235, 
0.413771942515432, 0.348013117283951, 0.364741271219136, 0.38968822337963, 
0.404763454861111, 0.38482349537037, 0.415417631172839, 0.385947145061728, 
0.386601803626543, 0.356246383101852, 0.372376543209877, 0.420251012731481, 
0.380846113040123, 0.402442611882716, 0.404289641203704, 0.374849295910494, 
0.405134789737654, 0.424883053626543, 0.369742235725309, 0.394878472222222, 
0.402324459876543, 0.408324893904321, 0.36083984375, 0.401047694830247, 
0.370205198688272, 0.399468315972222, 0.365071614583333, 0.387427662037037, 
0.386566840277778, 0.387134693287037, 0.341704041280864, 0.386242525077161, 
0.389988425925926, 0.394380545910494, 0.373389274691358, 0.386977961033951, 
0.372048611111111, 0.361917679398148, 0.360828993055556, 0.338351176697531, 
0.39232494212963, 0.376856674382716, 0.377413676697531, 0.375761959876543, 
0.417889178240741, 0.408604600694444, 0.419092399691358, 0.392327353395062, 
0.426388888888889, 0.386496913580247, 0.418935667438272, 0.369508342978395, 
0.389066116898148, 0.35234375, 0.409077208719136, 0.397744261188272, 
0.402287085262346, 0.412764033564815, 0.399705825617284, 0.395793547453704, 
0.390901089891975, 0.390275366512346, 0.425829475308642, 0.422141444830247, 
0.40127555941358, 0.425836709104938, 0.408755304783951, 0.43119212962963, 
0.394044174382716, 0.445629581404321, 0.38599537037037, 0.429912953317901, 
0.356674382716049, 0.410478153935185, 0.384129050925926, 0.423949893904321, 
0.419736207561728, 0.354499421296296, 0.411144868827161, 0.437016541280864, 
0.371636284722222, 0.384575135030864, 0.369868827160494, 0.417621527777778, 
0.384243586033951, 0.411648823302469, 0.398116801697531, 0.388364438657407, 
0.386033950617284, 0.415200617283951, 0.407120466820988, 0.373558063271605, 
0.41405647183642, 0.406703317901235, 0.378138261959877, 0.399733555169753, 
0.388875626929012, 0.42020278742284, 0.355137201003086, 0.351853057484568, 
0.377156876929012, 0.415581597222222, 0.397840711805556, 0.351316550925926, 
0.43052059220679, 0.408252555941358, 0.373283179012346, 0.364079378858025, 
0.370189525462963, 0.39624324845679, 0.371161265432099, 0.436905623070988, 
0.372820216049383, 0.416814959490741, 0.367123601466049, 0.382185570987654, 
0.422733410493827, 0.412718219521605, 0.380322868441358, 0.385768711419753, 
0.429175106095679, 0.392156153549383, 0.336970727237654, 0.42496021412037, 
0.404698350694444, 0.385574604552469, 0.417764998070988, 0.347227044753086, 
0.387035831404321, 0.418354552469136, 0.401291232638889, 0.382189187885802, 
0.367764998070988, 0.366671489197531, 0.399421296296296, 0.348514660493827, 
0.392493730709877, 0.362890625, 0.391638937114198, 0.426443142361111, 
0.379252266589506, 0.411027922453704, 0.370541570216049, 0.378446903935185, 
0.394773582175926, 0.413078703703704, 0.443235194830247, 0.401103153935185, 
0.403628954475309, 0.431617717978395, 0.394756703317901, 0.41430362654321, 
0.387205825617284, 0.356032986111111, 0.377866994598765, 0.427340133101852, 
0.430457899305556, 0.369756703317901, 0.40421127507716, 0.42396556712963, 
0.394716917438272, 0.344619261188272, 0.429246238425926, 0.358376736111111, 
0.373515866126543, 0.376716820987654, 0.415721450617284, 0.398945071373457, 
0.390829957561728, 0.415590036651235, 0.372623697916667, 0.411378761574074, 
0.362014130015432, 0.385200858410494, 0.42539665316358, 0.358989197530864, 
0.39154369212963, 0.409165219907407, 0.354264322916667, 0.382320601851852, 
0.392441888503086, 0.38319106867284, 0.415165653935185, 0.419118923611111, 
0.438945553626543, 0.383711902006173, 0.406321132330247, 0.420744116512346, 
0.393296682098765, 0.373635223765432, 0.382902922453704, 0.370631992669753, 
0.386036361882716, 0.395402922453704, 0.386788676697531, 0.386981577932099, 
0.38959659529321, 0.391449652777778, 0.355647183641975, 0.376593846450617, 
0.354891251929012, 0.343709008487654, 0.404910542052469, 0.393446180555556, 
0.363194444444444, 0.393581211419753, 0.381512827932099, 0.385577015817901, 
0.361928530092593, 0.436765769675926, 0.38978587962963)

## ----bd_histogram, resolution = 300-----------------------------------------------------
hist(bd.test, xlab = "Bruvo's Distance", main = "Average Bruvo's distance over 999 randomizations")
abline(v = observed, col = "red")
legend('topleft', legend="observed", col="red", lty = 1)

## ----informloci_command, echo = FALSE, comment = NA, size = 'normalsize'----------------
funk <- "informloci"
print_command(funk)

## ----inform.H3N2.1, eval = FALSE--------------------------------------------------------
#  data(H3N2)
#  H.five <- informloci(H3N2, cutoff = 0.05)

## ----inform.H3N2.2, echo = FALSE--------------------------------------------------------
res <- c(157,177,233,243,262,267,280,303,313,327,357,382,384,399,412,418,424,425,429,433,451,470,529,546,555,557,564,576,592,595,597,602,612,627,642,647,648,654,658,663,667,681,717,806,824,837,882)
cat("cutoff value: 5 percent ( 95 individuals ).\n","47 uninfomative loci found:", res, fill = 80)

## ----inform.nancy-----------------------------------------------------------------------
data(nancycats)
naninform <- informloci(nancycats, cutoff = 0.05)

## ----view_mlg---------------------------------------------------------------------------
virus

## ----mlg_genind-------------------------------------------------------------------------
virus_mlg <- mlg(virus)
virus_mlg

## ----mlg.crosspop_command, echo = FALSE, comment = NA, size = 'normalsize'--------------
funk <- "mlg.crosspop"
print_command(funk)

## ----crosspop, eval=FALSE---------------------------------------------------------------
#  setpop(virus) <- ~country
#  v.dup <- mlg.crosspop(virus, quiet=TRUE)

## ----crosspopout, echo=FALSE------------------------------------------------------------
setpop(virus) <- ~country
v.dup <- structure(list(MLG.3 = structure(c(4L, 8L), .Names = c("USA", 
"Denmark")), MLG.9 = structure(c(1L, 13L, 1L, 1L), .Names = c("Japan", 
"USA", "Finland", "Denmark")), MLG.31 = structure(c(2L, 7L), .Names = c("Japan", 
"Canada")), MLG.75 = structure(c(2L, 8L, 2L, 1L, 6L, 2L, 1L, 
1L), .Names = c("Japan", "USA", "Finland", "Norway", "Denmark", 
"Austria", "Russia", "Ireland")), MLG.80 = structure(c(1L, 1L
), .Names = c("USA", "Denmark")), MLG.86 = structure(3:4, .Names = c("Denmark", 
"Austria")), MLG.95 = structure(c(1L, 1L), .Names = c("USA", 
"Bangladesh")), MLG.97 = structure(c(1L, 5L, 1L, 1L), .Names = c("USA", 
"Austria", "Bangladesh", "Romania")), MLG.104 = structure(1:2, .Names = c("USA", 
"France")), MLG.110 = structure(c(2L, 3L, 11L), .Names = c("Japan", 
"USA", "China"))), .Names = c("MLG.3", "MLG.9", "MLG.31", "MLG.75", 
"MLG.80", "MLG.86", "MLG.95", "MLG.97", "MLG.104", "MLG.110"))
printthings <- function(ind, x){
  cat(paste0(names(x)[ind], ":"), 
      paste0("(", sum(x[[ind]])," inds)"), 
      names(x[[ind]]), 
      "\n")
}
invisible(lapply(1:10, printthings, v.dup))

## ----crosspop2--------------------------------------------------------------------------
head(v.dup)
v.num <- sapply(v.dup, length) # count the number of populations each MLG crosses.
head(v.num)

## ----mlg.table_command, echo = FALSE, comment = NA, size = 'normalsize'-----------------
funk <- "mlg.table"
print_command(funk)

## ----mlgbar, eval=FALSE-----------------------------------------------------------------
#  v.tab <- mlg.table(virus, quiet=TRUE, bar=TRUE)
#  v.tab[1:10, 1:10] # Showing the first 10 columns and rows of the table.

## ----echo=FALSE-------------------------------------------------------------------------
v.tab <- mlg.table(virus, quiet=TRUE, bar=FALSE)
v.tab[1:10, 1:10]

## ----mlgbarplot, echo=FALSE, results='hide'---------------------------------------------
mlg.table(virus, sublist="Norway", quiet=TRUE, bar=TRUE)

## ----mlgrare1_dummy, eval = FALSE-------------------------------------------------------
#  setpop(virus) <- ~year
#  summary(virus) # Check the data to make sure it's correct.

## ----mlgrare1, echo = FALSE-------------------------------------------------------------
setpop(virus) <- ~year
res <- structure(list(N = 1903L, pop.eff = structure(c(158, 415, 399, 
469, 462), .Names = c("2002", "2003", "2004", "2005", "2006")), 
    loc.nall = structure(c(3L, 3L, 4L, 2L, 4L, 2L, 3L, 2L, 4L, 
    3L, 4L, 2L, 4L, 3L, 2L, 2L, 3L, 3L, 2L, 2L, 3L, 3L, 3L, 2L, 
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 4L, 4L, 3L, 3L, 3L, 4L, 
    2L, 2L, 2L, 4L, 3L, 2L, 3L, 4L, 2L, 3L, 2L, 3L, 2L, 2L, 2L, 
    4L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 4L, 4L, 4L, 3L, 3L, 2L, 3L, 
    4L, 3L, 2L, 3L, 3L, 3L, 3L, 2L, 3L, 2L, 4L, 2L, 3L, 2L, 2L, 
    3L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 3L, 2L, 3L, 2L, 3L, 2L, 3L, 
    2L, 3L, 3L, 2L, 2L, 2L, 3L, 2L, 2L, 2L, 3L, 3L, 3L, 2L, 2L, 
    3L, 3L, 3L, 3L, 4L, 2L, 3L, 3L, 4L, 3L, 2L), .Names = c("L001", 
    "L002", "L003", "L004", "L005", "L006", "L007", "L008", "L009", 
    "L010", "L011", "L012", "L013", "L014", "L015", "L016", "L017", 
    "L018", "L019", "L020", "L021", "L022", "L023", "L024", "L025", 
    "L026", "L027", "L028", "L029", "L030", "L031", "L032", "L033", 
    "L034", "L035", "L036", "L037", "L038", "L039", "L040", "L041", 
    "L042", "L043", "L044", "L045", "L046", "L047", "L048", "L049", 
    "L050", "L051", "L052", "L053", "L054", "L055", "L056", "L057", 
    "L058", "L059", "L060", "L061", "L062", "L063", "L064", "L065", 
    "L066", "L067", "L068", "L069", "L070", "L071", "L072", "L073", 
    "L074", "L075", "L076", "L077", "L078", "L079", "L080", "L081", 
    "L082", "L083", "L084", "L085", "L086", "L087", "L088", "L089", 
    "L090", "L091", "L092", "L093", "L094", "L095", "L096", "L097", 
    "L098", "L099", "L100", "L101", "L102", "L103", "L104", "L105", 
    "L106", "L107", "L108", "L109", "L110", "L111", "L112", "L113", 
    "L114", "L115", "L116", "L117", "L118", "L119", "L120", "L121", 
    "L122", "L123", "L124", "L125")), pop.nall = structure(c(203L, 
    255L, 232L, 262L, 240L), .Names = c("1", "2", "3", "4", "5"
    )), NA.perc = 2.36342616920652, Hobs = 0, Xexp = 0), .Names = c("N", 
"pop.eff", "loc.nall", "pop.nall", "NA.perc", "Hobs", "Xexp"))
listlab <- c("# Total number of genotypes: ", "# Population sample sizes: ", 
    "# Number of alleles per locus: ", "# Number of alleles per population: ", 
    "# Percentage of missing data: ", "# Observed heterozygosity: ", 
    "# Expected heterozygosity: ")
cat("\n", listlab[1], res[[1]], "\n")
for (i in 2:7) {
    cat("\n", listlab[i], "\n")
    print(res[[i]])
}

## ----mlgrare2, eval=FALSE, tidy=FALSE---------------------------------------------------
#  library("vegan")
#  H.year <- mlg.table(virus, bar=FALSE)
#  rarecurve(H.year, ylab="Number of expected MLGs", sample=min(rowSums(H.year)),
#            border = NA, fill = NA, font = 2, cex = 1, col = "blue")

## ----mlgrareplot, echo=FALSE, results='hide'--------------------------------------------
# library("vegan")
H.year <- mlg.table(virus, bar=FALSE)
vegan::rarecurve(H.year, ylab="Number of expected MLGs", sample=min(rowSums(H.year)), border = NA, fill = NA, font = 2, cex = 1, col = "blue")

## ----subcross---------------------------------------------------------------------------
setpop(virus) <- ~country
UGNN.list <- c("United Kingdom", "Germany", "Netherlands", "Norway")
UGNN <- mlg.crosspop(virus, sublist=UGNN.list, indexreturn=TRUE)

## ----subtable---------------------------------------------------------------------------
UGNN # Note that we have three numbers here. This will index the columns for us.
UGNN.list # And let's not forget that we have the population names.
v.tab[UGNN.list, UGNN]

## ----mlg.vector_first-------------------------------------------------------------------
v.vec <- mlg.vector(virus)
str(v.vec) # Analyze the structure.

## ----mlg.vector_second------------------------------------------------------------------
length(unique(v.vec)) # count the number of MLGs
virus # equal to the first number in this output.

## ----mlg.vector_match-------------------------------------------------------------------
UGNN # Show what we are looking for
UGNN_match <- v.vec %in% UGNN
table(UGNN_match) # How many individuals matched to those three MLGs?

## ----mlg.vector_inds--------------------------------------------------------------------
indNames(virus)[UGNN_match]

## ----mlg.id-----------------------------------------------------------------------------
virus.id <- mlg.id(virus)
virus.id[as.character(UGNN)]

## ----mlgsub_flag, eval=FALSE------------------------------------------------------------
#  mlg.table(virus, mlgsub = UGNN, bar = TRUE)

## ----mlgsub_flagshow, echo=FALSE--------------------------------------------------------
mlg.table(virus, mlgsub = UGNN, bar = FALSE)

## ----subnor, results='hide', echo=FALSE-------------------------------------------------
mlg.table(virus, sublist = "Norway", mlgsub = UGNN)

## ----hier_syntax, eval = FALSE----------------------------------------------------------
#  newobject <- FUNCTION(object, input)

## ----Pinf_load--------------------------------------------------------------------------
data(Pinf)
Pinf

## ----Pinf_rename------------------------------------------------------------------------
elPinf <- namehierarchy(Pinf, ~continente/pais) # Don't forget the formula syntax!
elPinf
Pinf

## ----hier_syntax_replace, eval = FALSE--------------------------------------------------
#  FUNCTION(object) <- input

## ----Pinf_replace-----------------------------------------------------------------------
Pinf
namehierarchy(Pinf) <- ~continente/pais
Pinf

## ----Aeut_MLG_Ahena---------------------------------------------------------------------
library("poppr")
library("ggplot2")
data(Aeut)
Athena.tab <- mlg.table(Aeut, sublist = "Athena")
p <- last_plot()

## ----Aeut_MLG_black---------------------------------------------------------------------
(pb <- p + scale_fill_continuous(low = "black", high = "black", guide = "none"))

## ----Aeut_MLG_title---------------------------------------------------------------------
(pbt <- pb + ggtitle("Distribution of multilocus genotypes for the Athena population")) + xlab("Multilocus genotype")

## ----Aeut_MLG_data----------------------------------------------------------------------
head(p$data)

## ----ggsave1, eval=FALSE----------------------------------------------------------------
#  data(nancycats) # Load the data set.
#  poppr(nancycats, sublist=5, sample=999) # Produce a single plot.
#  ggsave("nancy5.pdf")

## ----png_save, eval=FALSE---------------------------------------------------------------
#  data(H3N2)
#  pop(H3N2) <- H3N2$other$x$country
#  ####
#  png("H3N2_barchart%02d.png", width = 14, height = 14, units = "in", res = 300)
#  H.tab <- mlg.table(H3N2)
#  dev.off()
#  ####

## ----pdf_save, eval=FALSE---------------------------------------------------------------
#  pdf("H3N2_barcharts.png", width = 14, height = 14, compress = FALSE)
#  H.tab <- mlg.table(H3N2)
#  dev.off()

