% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_QmatfromF2samples}
\alias{compute_QmatfromF2samples}
\alias{.compute_QmatfromF2samples}
\title{compute_QmatfromF2samples}
\usage{
.compute_QmatfromF2samples(blockF2, npops, verbose)
}
\arguments{
\item{blockF2}{Numeric Matrix with nF2=(npop*(npop-1))/2 rows and nblocks columns matrix containing pairwise-pop F2 estimates for each block-jackknife sample (l.o.o.)}

\item{npops}{Integer giving the number of populations}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return the (nF2+nF3)*(nF2+nF3) error covariance (symmetric) matrix
}
\description{
Compute the Qmat matrix (error covariance between all F2 and F3 measures) from F2 block-jackknife estimates
}
\details{
Compute the error covariance matrix Qmat (between all F2 and F3 measures) from F2 block-jackknife estimates (by recomuting all F3 for all blocks)
}
\examples{
#
}
