% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{set_alpha}
\alias{set_alpha}
\title{Correct alpha value}
\usage{
set_alpha(alpha_i)
}
\arguments{
\item{alpha_i}{is a vector of shape parameters for the Dirichlet
distribution.}
}
\value{
a vector of corrected shape parameters for the Dirichlet
distribution. Very small values are replaced by a minimum value.
}
\description{
This function corrects the alpha value of the Dirichlet distribution used to
simulate the probability of contribution of different pools and individuals.
}
\details{
The alpha value corresponds to the vector of shape parameters of the
Dirichlet distribution. When the alpha is very small, the random generation
of numbers from the Dirichlet distribution produces \code{NaN}. Thus, this
function replaces small values of alpha with a minimum threshold value to
avoid that.
}
\keyword{internal}
