% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{computeReference}
\alias{computeReference}
\title{Compute the number of reference reads over a matrix}
\usage{
computeReference(genotypes, indContribution, error)
}
\arguments{
\item{genotypes}{is a matrix of genotypes. Each column of the matrix should
be a different site and each row a different individual. Genotypes should
be encoded as 0: reference homozygote, 1: heterozygote and 2: alternative
homozygote.}

\item{indContribution}{is a matrix of individual contributions. Each row of
that matrix is a different individual and each column is a different site.
Thus, each entry of the matrix should contain the number of reads
contributed by that individual at that particular site.}

\item{error}{a numeric value with error rate associated with the sequencing
and mapping process. This error rate is assumed to be symmetric:
error(reference -> alternative) = error(alternative -> reference). This
number should be between 0 and 1.}
}
\value{
a matrix with the number of reference allele reads contributed by
each individual. Each row of the matrix represents a different individual
and each column is a different site.
}
\description{
This function works over all the rows and columns of a matrix and computes
the number of reads containing the reference allele at each site and for each
individual.
}
\examples{
# probability of contribution for 10 individuals at 5 sites
probs <- indProbs(np = 10, nSNPs = 5, pError = 5)

# simulate the number of reads contributed, assuming 20 coverage for each site
indContribution <- indReads(np = 10, coverage = rep(20, 5), probs = probs)

# set seed and create a random matrix of genotypes
set.seed(10)
genotypes <- matrix(rpois(50, 0.5), nrow = 10)

# simulate the number of reads with the reference allele
computeReference(genotypes = genotypes, indContribution = indContribution, error = 0.01)

}
