% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builder.R
\docType{methods}
\name{hitch}
\alias{hitch}
\title{Hitching C snippets and R functions to pomp_fun objects}
\usage{
hitch(
  ...,
  templates,
  obsnames,
  statenames,
  paramnames,
  covarnames,
  PACKAGE,
  globals,
  cfile,
  cdir = getOption("pomp_cdir", NULL),
  shlib.args,
  compile = TRUE,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{\dots}{named arguments representing the user procedures to be hitched.
These can be functions, character strings naming routines in external, dynamically-linked libraries, C snippets, or \code{NULL}.
The first three are converted by \code{hitch} to \sQuote{pomp_fun} objects which perform the indicated computations.
\code{NULL} arguments are translated to default \sQuote{pomp_fun} objects.
If any of these procedures are already \sQuote{pomp_fun} objects, they are returned unchanged.}

\item{templates}{named list of templates.
Each workhorse must have a corresponding template.
See \code{pomp:::workhorse_templates} for a list.}

\item{obsnames, statenames, paramnames, covarnames}{character vectors
specifying the names of observable variables, latent state variables, parameters, and covariates, respectively.
These are only needed if one or more of the horses are furnished as C snippets.}

\item{PACKAGE}{optional character;
the name (without extension) of the external, dynamically loaded library in which any native routines are to be found.
This is only useful if one or more of the model components has been specified using a precompiled dynamically loaded library;
it is not used for any component specified using C snippets.
\code{PACKAGE} can name at most one library.}

\item{globals}{optional character;
arbitrary C code that will be hard-coded into the shared-object library created when C snippets are provided.
If no C snippets are used, \code{globals} has no effect.}

\item{cfile}{optional character variable.
\code{cfile} gives the name of the file (in directory \code{cdir}) into which C snippet codes will be written.
By default, a random filename is used.
If the chosen filename would result in over-writing an existing file, an error is generated.}

\item{cdir}{optional character variable.
\code{cdir} specifies the name of the directory within which C snippet code will be compiled.
By default, this is in a temporary directory specific to the \R session.
One can also set this directory using the \code{pomp_cdir} global option.}

\item{shlib.args}{optional character variables.
Command-line arguments to the \code{R CMD SHLIB} call that compiles the C snippets.
One can, for example, specify libraries against which the C snippets are to be linked.
In doing so, take care to make sure the appropriate header files are available to the C snippets, e.g., using the \code{globals} argument.
See \code{\link{Csnippet}} for more information.}

\item{compile}{logical;
if \code{FALSE}, compilation of the C snippets will be postponed until they are needed.}

\item{verbose}{logical.
Setting \code{verbose=TRUE} will cause additional information to be displayed.}
}
\value{
\code{hitch} returns a named list of length two.  The element named
\dQuote{funs} is itself a named list of \sQuote{pomp_fun} objects, each of
which corresponds to one of the horses passed in.  The element named
\dQuote{lib} contains information on the shared-object library created
using the C snippets (if any were passed to \code{hitch}).  If no C
snippets were passed to \code{hitch}, \code{lib} is \code{NULL}.
Otherwise, it is a length-3 named list with the following elements:
\describe{
\item{name}{The name of the library created.}
\item{dir}{ The
directory in which the library was created.  If this is \code{NULL}, the
library was created in the session's temporary directory.  }
\item{src}{ A
character string with the full contents of the C snippet file.  } }
}
\description{
The algorithms in \pkg{pomp} are formulated using \R functions that access the \link[=basic components]{basic model components}
(\code{rprocess}, \code{dprocess}, \code{rmeasure}, \code{dmeasure}, etc.).
For short, we refer to these elementary functions as \dQuote{\link{workhorses}}.
In implementing a model, the user specifies basic model components
using functions, procedures in dynamically-linked libraries, or C snippets.
Each component is then packaged into a \sQuote{pomp_fun} objects, which gives a uniform interface.
The construction of \sQuote{pomp_fun} objects is handled by the \code{hitch} function,
which conceptually \dQuote{hitches} the workhorses to the user-defined procedures.
}
\seealso{
\code{\link{pomp}}, \code{\link{spy}}
}
\author{
Aaron A. King
}
\concept{extending the pomp package}
\concept{low-level interface}
