% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_var.R
\docType{methods}
\name{pred.var}
\alias{pred.var}
\alias{pred.var,ANY-method}
\alias{pred.var,missing-method}
\alias{pred.var-pfilterd_pomp}
\alias{pred.var,pfilterd_pomp-method}
\title{Prediction variance}
\usage{
\S4method{pred.var}{pfilterd_pomp}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}
}
\description{
The variance of the prediction distribution
}
\details{
The prediction distribution is that of
\deqn{X_t \vert Y_1=y^*_1,\dots,Y_{t-1}=y^*_{t-1},}{Xt | Y1=y1*,\dots,Y(t-1)=y(t-1)*,}
where \eqn{X_t}{Xt}, \eqn{Y_t}{Yt} are the latent state and observable processes, respectively, and \eqn{y^*_t}{yt*} is the data, at time \eqn{t}.

The prediction variance is therefore the variance of this distribution
\deqn{\mathrm{Var}[X_t \vert Y_1=y^*_1,\dots,Y_{t-1}=y^*_{t-1}].}{Var[Xt | Y1=y1*,\dots,Y(t-1)=y(t-1)*].}
}
\seealso{
Other particle filter methods: \code{\link{bsmc2}},
  \code{\link{cond.logLik}}, \code{\link{eff.sample.size}},
  \code{\link{filter.mean}}, \code{\link{filter.traj}},
  \code{\link{mif2}}, \code{\link{pfilter}},
  \code{\link{pmcmc}}, \code{\link{pred.mean}}
}
\concept{particle filter methods}
