\name{rmeasure-pomp}
\docType{methods}
\alias{rmeasure}
\alias{rmeasure,pomp-method}
\alias{rmeasure-pomp}
\title{Simulate the measurement model of a partially-observed Markov process}
\description{
  The method \code{rmeasure} draws from the distribution of measurements given the state of the system.
}
\usage{
rmeasure(object, x, times, params, \dots)
\S4method{rmeasure}{pomp}(object, x, times, params, \dots)
}
\arguments{
  \item{object}{an object of class \code{pomp}.}
  \item{x}{
    a rank-3 array containing the states of the unobserved process.
    The dimensions of \code{x} are \code{nvars} x \code{nsims} x \code{ntimes}, where \code{nvars} is the number of state variables, \code{nsims} is the number of simulations, and \code{ntimes} is the number of distinct times.
    Note that if \code{ntimes!=length(times)}, an error is generated.
  }
  \item{times}{
    a numerical vector containing the times at which the measurements are to be made.
  }
  \item{params}{
    a rank-2 array (dimensions \code{npars} x \code{nsims}) of parameters with the parameters corresponding to the columns of \code{x}.
  }
  \item{\dots}{
    at present, these are ignored.
  }
}
\value{
  Returns a rank-3 array of dimensions \code{nobs} x \code{nsims} x \code{ntimes}, where \code{nobs} is the number of observed variables.
}
\details{
  This function is essentially a wrapper around the user-supplied \code{rmeasure} slot of the \code{pomp} object.
  For specifications on writing such a function, see \code{\link{pomp}}.
}
\references{}
\author{Aaron A. King (kingaa at umich dot edu)}
\seealso{\code{\link{pomp-class}}, \code{\link{pomp}}}
\keyword{models}
\keyword{ts}
