% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAb.R
\name{getAb}
\alias{getAb}
\title{Easily get the matrix \code{A} and the vector \code{b}}
\usage{
getAb(model)
}
\arguments{
\item{model}{a "MIP model"; see the example}
}
\value{
A list with the matrix \code{A} and the vector \code{b} for usage in
  \code{\link{integrateOverPolyhedron}}.
}
\description{
Get the matrix \code{A} and the vector \code{b} representing
 the linear inequalities with a user-friendly syntax.
}
\examples{
library(ompr)
model <- MIPModel() \%>\%
  add_variable(x) \%>\% add_variable(y) \%>\% add_variable(z) \%>\%
  add_constraint(-5 <= x) \%>\% add_constraint(x <= 4) \%>\%
  add_constraint(-5 <= y) \%>\% add_constraint(y <= 3 - x) \%>\%
  add_constraint(-10 <= z) \%>\% add_constraint(z <= 6 - x - y)
getAb(model)
}
