% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/corpus.R, R/size.R
\docType{class}
\name{subcorpus}
\alias{subcorpus}
\alias{subcorpus-class}
\alias{remote_subcorpus-class}
\alias{summary,subcorpus-method}
\alias{name<-,subcorpus-method}
\alias{plpr_subcorpus-class}
\alias{press_subcorpus-class}
\alias{get_corpus,subcorpus-method}
\alias{size,subcorpus-method}
\title{The S4 subcorpus class.}
\usage{
\S4method{summary}{subcorpus}(object)

\S4method{name}{subcorpus}(x) <- value

\S4method{get_corpus}{subcorpus}(x)

\S4method{size}{subcorpus}(x, s_attribute = NULL, ...)
}
\arguments{
\item{object}{A \code{subcorpus} object.}

\item{x}{A \code{subcorpus} object.}

\item{value}{A \code{character} vector to assign as name to slot \code{name}
of a \code{subcorpus} class object.}

\item{s_attribute}{A \code{character} vector with s-attributes (one or more).}

\item{...}{Arguments passed into \code{size}-method. Used only to maintain
backwards compatibility.}
}
\description{
Class to manage subcorpora derived from a CWB corpus.
}
\section{Methods (by generic)}{
\itemize{
\item \code{summary}: Get named list with basic information for
\code{subcorpus} object.

\item \code{name<-}: Assign name to a \code{subcorpus} object.

\item \code{get_corpus}: Get the corpus ID from the \code{subcorpus} object.

\item \code{size}: Get the size of a \code{subcorpus} object from the
respective slot of the object.
}}

\section{Slots}{

\describe{
\item{\code{s_attributes}}{A named \code{list} with the structural attributes
defining the subcorpus.}

\item{\code{cpos}}{A \code{matrix} with left and right corpus positions defining
regions (two column matrix with \code{integer} values).}

\item{\code{annotations}}{Object of class \code{list}.}

\item{\code{size}}{Total size (number of tokens) of the \code{subcorpus} object (a
length-one \code{integer} vector). The value is accessible by calling 
the \code{size}-method on the \code{subcorpus}-object (see examples).}

\item{\code{metadata}}{Object of class \code{data.frame}, metadata information.}

\item{\code{strucs}}{Object of class \code{integer}, the strucs defining the
subcorpus.}

\item{\code{xml}}{Object of class \code{character}, whether the xml is "flat" or
"nested".}

\item{\code{s_attribute_strucs}}{Object of class \code{character}, the base node.}

\item{\code{user}}{If the corpus on the server requires authentication, the username.}

\item{\code{password}}{If the corpus on the server requires authentication, the password.}
}}

\examples{
use("polmineR")

# basic example 
r <- corpus("REUTERS")
k <- subset(r, grepl("kuwait", places))
name(k) <- "kuwait"
y <- summary(k)
s <- size(k)

# the same with a magrittr pipe
corpus("REUTERS") \%>\%
  subset(grepl("kuwait", places)) \%>\%
  summary()
  
# subsetting a subcorpus in a pipe
stone <- corpus("GERMAPARLMINI") \%>\%
  subset(date == "2009-11-10") \%>\%
  subset(speaker == "Frank-Walter Steinmeier")

# perform count for subcorpus
n <- corpus("REUTERS") \%>\% subset(grep("kuwait", places)) \%>\% count(p_attribute = "word")
n <- corpus("REUTERS") \%>\% subset(grep("saudi-arabia", places)) \%>\% count('"Saudi" "Arabia"')
  
# keyword-in-context analysis (kwic)   
k <- corpus("REUTERS") \%>\% subset(grep("kuwait", places)) \%>\% kwic("oil")

}
\seealso{
Most commonly, a \code{subcorpus} is derived from a \code{corpus} or
  a \code{subcorpus} using the \code{\link{subset}} method. See
  \code{\link{size}} for detailed documentation on how to use the
  \code{size}-method. The \code{subcorpus} class shares many features with
  the \code{partition} class, but it is more parsimonious and does not
  include information on statistical properties of the subcorpus (i.e. a
  count table). In line with this logic, the \code{subcorpus} class inherits
  from the \code{corpus} class, whereas the \code{partition} class inherits
  from the \code{textstat} class.

Other classes to manage corpora: 
\code{\link{corpus-class}},
\code{\link{phrases}},
\code{\link{regions}}
}
\concept{classes to manage corpora}
