% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\docType{methods}
\name{get_type}
\alias{get_type}
\alias{get_type,character-method}
\alias{get_type,Corpus-method}
\alias{get_type,partition-method}
\alias{get_type,partition_bundle-method}
\title{Get corpus/partition type.}
\usage{
get_type(.Object)

\S4method{get_type}{character}(.Object)

\S4method{get_type}{Corpus}(.Object)

\S4method{get_type}{partition}(.Object)

\S4method{get_type}{partition_bundle}(.Object)
}
\arguments{
\item{.Object}{A \code{partition}, \code{partition_bundle}, \code{Corpus}
object, or a length-one character vector indicating a CWB corpus.}
}
\description{
To generate fulltext output, different templates can be used with a behavior
that depends on the type of a corpus. \code{get_type} will return the type of corpus
if it is a specialized one, or \code{NULL}.
}
\details{
When generating a \code{partition}, the corpus type will be prefixed to the class
that is generated (separated by underscore). If the corpus type is not \code{NULL},
a class inheriting from the \code{partition}-class is instantiated. Note that at
this time, only \code{plpr_partition} and \code{press_partition} is implemented.
}
\examples{
use("polmineR")

get_type("GERMAPARLMINI")

p <- partition("GERMAPARLMINI", date = "2009-10-28")
get_type(p)
is(p)

pb <- partition_bundle("GERMAPARLMINI", s_attribute = "date")
get_type(pb)

gp <- Corpus$new("GERMAPARLMINI") 
get_type(gp)

get_type("REUTERS") # returns NULL - no specialized corpus
}
