% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_cast_time_unit}
\alias{ExprDT_cast_time_unit}
\alias{(Expr)$dt$cast_time_unit}
\title{cast_time_unit}
\format{
function
}
\arguments{
\item{tu}{string option either 'ns', 'us', or 'ms'}
}
\value{
Expr of i64
}
\description{
Cast the underlying data to another time unit. This may lose precision.
The corresponding global timepoint will stay unchanged +/- precision.
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    low = as.Date("2001-1-1"),
    high = as.Date("2001-1-3"),
    interval = "1d",
    lazy = FALSE
  )
)
df$select(
  pl$col("date"),
  pl$col("date")$dt$cast_time_unit()$alias("cast_time_unit_ns"),
  pl$col("date")$dt$cast_time_unit(tu = "ms")$alias("cast_time_unit_ms")
)
}
\keyword{ExprDT}
