% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe__frame.R
\name{DataFrame_with_columns}
\alias{DataFrame_with_columns}
\alias{with_columns}
\alias{DataFrame_with_column}
\alias{with_column}
\title{Modify/append column(s)}
\usage{
DataFrame_with_columns(...)

DataFrame_with_column(expr)
}
\arguments{
\item{...}{any expressions or string column name, or same wrapped in a list}

\item{expr}{a single expression or string}
}
\value{
DataFrame

DataFrame
}
\description{
Add or modify columns with expressions
}
\details{
Like dplyr \code{mutate()} as it keeps unmentioned columns unlike $select().

with_column is derived from with_columns but takes only one expression argument
}
\examples{
pl$DataFrame(iris)$with_columns(
  pl$col("Sepal.Length")$abs()$alias("abs_SL"),
  (pl$col("Sepal.Length") + 2)$alias("add_2_SL")
)

# rename columns by naming expression is concidered experimental
pl$set_polars_options(named_exprs = TRUE) # unlock
pl$DataFrame(iris)$with_columns(
  pl$col("Sepal.Length")$abs(), # not named expr will keep name "Sepal.Length"
  SW_add_2 = (pl$col("Sepal.Width") + 2)
)
}
\keyword{DataFrame}
