% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{topN}
\alias{topN}
\title{Rank top-N highest-predicted items for an existing user}
\usage{
topN(model, user, n = 10, include = NULL, exclude = NULL, output_score = FALSE)
}
\arguments{
\item{model}{A Poisson factorization model as returned by `poismf`.}

\item{user}{User for which to rank the items. If `X` passed to `poismf` was a
`data.frame`, must match with the entries in its first column,
otherwise should match with the rows of `X` (numeration starting at 1).}

\item{n}{Number of top-N highest-predicted results to output.}

\item{include}{List of items which will be ranked. If passing this, will only
make a ranking among these items. If `X` passed to `poismf` was a
`data.frame`, must match with the entries in its second column,
otherwise should match with the columns of `X` (numeration starting at 1). Can only pass
one of `include` or `exclude.` Must not contain duplicated entries.}

\item{exclude}{List of items to exclude from the ranking. If passing this, will
rank all the items except for these. If `X` passed to `poismf` was a
`data.frame`, must match with the entries in its second column,
otherwise should match with the columns of `X` (numeration starting at 1). Can only pass
one of `include` or `exclude`. Must not contain duplicated entries.}

\item{output_score}{Whether to output the scores in addition to the IDs. If passing
`FALSE`, will return a single array with the item IDs, otherwise
will return a list with the item IDs and the scores.}
}
\value{
\itemize{
  \item If passing `output_score=FALSE` (the default), will return a vector of size `n`
  with the top-N highest predicted items for this user.If the `X` data passed to
  `poismf` was a `data.frame`, will contain the item IDs from its second column,
  otherwise will be integers matching to the columns of `X` (starting at 1). If
  `X` was passed as `data.frame`, the entries in this vector might be coerced to
  character regardless of their original type.
  \item If passing `output_score=TRUE`, will return a list, with the first entry
  being the vector described above under name `ix`, and the second entry being the
  associated scores, as a numeric vector of size `n`.
}
}
\description{
Rank top-N highest-predicted items for an existing user
}
\seealso{
\link{topN.new} \link{predict.poismf} \link{factors.single}
}
