% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationModel.R
\name{PopulationModel}
\alias{PopulationModel}
\title{R6 class representing a population model}
\description{
\code{\link[R6:R6Class]{R6}} class representing a spatially-explicit
demographic-based population model. It extends the \code{\link{SimulationModel}}
class with parameters for the \code{\link{population_simulator}} function. It
inherits functionality for creating a nested model, whereby a nested template model
with fixed parameters is maintained when a model is cloned for various sampled
parameters. Also provided are extensions to the methods for checking the consistency
and completeness of model parameters.
}
\examples{
# U Island example region
coordinates <- data.frame(
  x = rep(seq(177.01, 177.05, 0.01), 5),
  y = rep(seq(-18.01, -18.05, -0.01), each = 5)
)
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
# Harvest function
harvest <- list(
  rate = NA, # set later
  function(params) round(params$stage_abundance * (1 - params$rate))
)
harvest_rate_alias <- list(harvest_rate = "harvest$rate")
# Template model
stage_matrix <- matrix(c(
  0, 2.5, # Leslie/Lefkovitch matrix
  0.8, 0.5
), nrow = 2, ncol = 2, byrow = TRUE)
template_model <- PopulationModel$new(
  region = region,
  time_steps = 10, # years
  populations = region$region_cells, # 7
  stage_matrix = stage_matrix,
  harvest = harvest,
  results_selection = c("abundance", "harvested"),
  attribute_aliases = harvest_rate_alias
)
template_model$model_attributes
template_model$required_attributes
# Nested model
nested_model <- PopulationModel$new(template_model = template_model)
nested_model$incomplete_attributes()
nested_model$set_sample_attributes(
  initial_abundance = rep(10, 7),
  carrying_capacity = array(70:1, c(10, 7)),
  harvest_rate = 0.3
)
nested_model$inconsistent_attributes()
nested_model$carrying_capacity <- array(70:1, c(7, 10))
nested_model$is_consistent()
nested_model$is_complete()
nested_model$harvest$rate

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{\link[poems:SimulationModel]{poems::SimulationModel}} -> \code{PopulationModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{simulation_function}}{Name (character string) or source path of the default simulation function, which takes a model as an input and returns the simulation results.}

\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{random_seed}}{Number to seed the random number generation for stochasticity.}

\item{\code{replicates}}{Number of replicate simulation runs.}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{years_per_step}}{Number of years per time step.}

\item{\code{populations}}{Number of population cells.}

\item{\code{stages}}{Number of life cycle stages.}

\item{\code{initial_abundance}}{Array (matrix) or raster (stack) of initial abundance values at each population cell (for each age/stage).}

\item{\code{stage_matrix}}{Matrix of transition (fecundity & survival) rates between stages at each time step (Leslie/Lefkovitch matrix).}

\item{\code{fecundity_mask}}{Matrix of 0-1 to indicate which (proportions) of transition rates refer to fecundity.}

\item{\code{fecundity_max}}{Maximum transition fecundity rate (in Leslie/Lefkovitch matrix).}

\item{\code{demographic_stochasticity}}{Boolean for choosing demographic stochasticity for transition, dispersal, harvest and/or other processes.}

\item{\code{standard_deviation}}{Standard deviation matrix (or single value) for applying environmental stochasticity to transition rates.}

\item{\code{correlation}}{Simulator-dependent attribute or list of attributes for describing/parameterizing the correlation strategy utilized when applying environmental stochasticity and/or other processes (see \code{\link{population_simulator}}).}

\item{\code{carrying_capacity}}{Array (matrix), or raster (stack) of carrying capacity values at each population cell (across time).}

\item{\code{density_dependence}}{Simulator-dependent function, attribute or list of attributes for describing/parameterizing the density dependence strategy utilized (see \code{\link{population_simulator}}).}

\item{\code{growth_rate_max}}{Maximum growth rate (utilized by density dependence processes).}

\item{\code{density_affects}}{Transition vital rates that are affected by density, including \emph{"fecundity"}, \emph{"survival"}, or a matrix of booleans or numeric (0-1) indicating vital rates affected (default is all).}

\item{\code{density_stages}}{Array of booleans or numeric (0-1) for each stage to indicate (the degree to) which stages are affected by density (default is 1 for all stages).}

\item{\code{translocation}}{Simulator-dependent function, attribute or list of attributes for describing/parameterizing translocation (management) strategies utilized (see \code{\link{population_simulator}}).}

\item{\code{harvest}}{Simulator-dependent function, attribute or list of attributes for describing/parameterizing a harvest (organism removal/hunting) strategy (see \code{\link{population_simulator}}).}

\item{\code{mortality}}{Simulator-dependent function, attribute or list of attributes to describe/parameterize a spatio-temporal mortality strategy (see \code{\link{population_simulator}}).}

\item{\code{dispersal}}{Simulator-dependent function, attribute or list of attributes for describing/parameterizing the dispersal (migration) strategy utilized (see \code{\link{population_simulator}}).}

\item{\code{dispersal_stages}}{Array of relative dispersal (0-1) for each stage
to indicate the degree to which each stage participates in dispersal
(default is 1 for all stages). This factor modifies dispersal
proportion, not dispersal rate.}

\item{\code{dispersal_source_n_k}}{Simulator-dependent attribute for describing/parameterizing dispersal dependent on source population abundance divided by carrying capacity (see \code{\link{population_simulator}}).}

\item{\code{dispersal_target_k}}{Simulator-dependent attribute for describing/parameterizing dispersal dependent on target population carrying capacity (see \code{\link{population_simulator}}).}

\item{\code{dispersal_target_n}}{Simulator-dependent attribute (default is list with \emph{threshold} and \emph{cutoff}) of attributes for describing/parameterizing dispersal dependent on target population abundance (see \code{\link{population_simulator}}).}

\item{\code{dispersal_target_n_k}}{Simulator-dependent attribute (default is list with \emph{threshold} and \emph{cutoff}) of attributes for describing/parameterizing dispersal dependent on target population abundance/capacity (see \code{\link{population_simulator}}).}

\item{\code{abundance_threshold}}{Abundance threshold (that needs to be exceeded) for each population to persist.}

\item{\code{simulation_order}}{A vector of simulation process names in configured order of execution (default is "transition", "translocation", "harvest", "mortality", "dispersal", "results").}

\item{\code{results_selection}}{List of attributes to be included in the returned results of each simulation run, selected from: "abundance", "ema", "extirpation", "extinction_location", "harvested", "occupancy"; "summarize" or "replicate".}

\item{\code{result_stages}}{Array of booleans or numeric (0, 1, 2, ...) for each stage to indicate which stages are included/combined (each unique digit > 0; optionally named) in the results (default is 1 for all stages).}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{template_model}}{Nested template model for fixed (non-sampled) attributes for shallow cloning.}

\item{\code{sample_attributes}}{Vector of sample attribute names (only).}

\item{\code{required_attributes}}{Vector of required attribute names (only), i.e. those needed to run a simulation.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PopulationModel-new}{\code{PopulationModel$new()}}
\item \href{#method-PopulationModel-list_consistency}{\code{PopulationModel$list_consistency()}}
\item \href{#method-PopulationModel-clone}{\code{PopulationModel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="get_attribute_names"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-get_attribute_names'><code>poems::SimulationModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="get_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-get_attributes'><code>poems::SimulationModel$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="incomplete_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-incomplete_attributes'><code>poems::SimulationModel$incomplete_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="inconsistent_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-inconsistent_attributes'><code>poems::SimulationModel$inconsistent_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="is_complete"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-is_complete'><code>poems::SimulationModel$is_complete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="is_consistent"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-is_consistent'><code>poems::SimulationModel$is_consistent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="list_completeness"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-list_completeness'><code>poems::SimulationModel$list_completeness()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="new_clone"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-new_clone'><code>poems::SimulationModel$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="set_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-set_attributes'><code>poems::SimulationModel$set_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="set_sample_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-set_sample_attributes'><code>poems::SimulationModel$set_sample_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PopulationModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-PopulationModel-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets default aliases and given attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PopulationModel$new(attribute_aliases = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PopulationModel-list_consistency"></a>}}
\if{latex}{\out{\hypertarget{method-PopulationModel-list_consistency}{}}}
\subsection{Method \code{list_consistency()}}{
Returns a boolean to indicate if (optionally selected or all) model attributes (such as dimensions) are consistent.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PopulationModel$list_consistency(params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Optional array of parameter/attribute names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of booleans (or NAs) to indicate consistency of selected/all attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PopulationModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PopulationModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PopulationModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
