% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_omega.R
\name{get_omega}
\alias{get_omega}
\title{Extract variability parameter estimates from a NONMEM output object.}
\usage{
get_omega(x, output = "est", sigdig = 6, sep = "-", est.step = NULL)
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the matrix or matrices to be output. Valid flag values are \code{est} (the default),
\code{se}, \code{rse}, \code{cor}, \code{cse}, \code{95ci}, or \code{all}.}

\item{sigdig}{Specifies the number of significant digits to be provided (default=6).}

\item{sep}{Specifies the separator character to use for 95\% confidence intervals (default="-").}

\item{est.step}{Specifies which estimation step to return parameters from (default is the last).}
}
\value{
A symmetrical matrix, or a list of symmetrical matrices if \code{all} is specified.
}
\description{
Extract variability parameter estimates from a NONMEM output object.
}
\examples{
\dontrun{
 nmOutput  <- read_nm("run315.xml")
 omegas    <- get_omega(nmOutput)
 omegaRSEs <- get_omega(nmOutput, "rse")
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}

\code{est} returns the estimated OMEGA variance-covariance matrix.
\code{se} returns the standard errors for the estimated OMEGA variance-covariance matrix.
\code{rse} returns the relative standard errors for the estimated OMEGA variance-covariance matrix (se/est*100).
\code{cor} returns the correlation matrix matrix.
\code{cse} returns the standard errors for the correlation matrix.
\code{95ci} returns the asymptotic 95\% confidence intervals for the elements of the OMEGA variance-covariance
matrix (est +/- 1.96*se).
\code{all} returns all available OMEGA matrices.
}
