% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimation.R
\name{particleMetropolisHastings}
\alias{particleMetropolisHastings}
\title{Particle Metropolis-Hastings algorithm for a linear Gaussian state space 
model}
\usage{
particleMetropolisHastings(y, initialPhi, sigmav, sigmae, 
  noParticles, initialState, noIterations, stepSize)
}
\arguments{
\item{y}{Observations from the model for \eqn{t=1,...,T}.}

\item{initialPhi}{The mean of the log-volatility process \eqn{\mu}.}

\item{sigmav}{The standard deviation of the state process \eqn{\sigma_v}.}

\item{sigmae}{The standard deviation of the observation process 
\eqn{\sigma_e}.}

\item{noParticles}{The number of particles to use in the filter.}

\item{initialState}{The inital state.}

\item{noIterations}{The number of iterations in the PMH algorithm.}

\item{stepSize}{The standard deviation of the Gaussian random walk proposal 
for \eqn{\phi}.}
}
\value{
The trace of the Markov chain exploring the marginal posterior for 
\eqn{\phi}.
}
\description{
Estimates the parameter posterior for \eqn{phi} a linear Gaussian state 
space model of the form \eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } and 
\eqn{ y_t = x_t + \sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote 
independent standard Gaussian random variables, i.e.\eqn{N(0,1)}.
}
\note{
See Section 4 in the reference for more details.
}
\examples{
\dontshow{
  noIterations <- 10

  # Generates 100 observations from a linear state space model with
  # (phi, sigma_e, sigma_v) = (0.5, 1.0, 0.1) and zero initial state.
  theta <- c(0.5, 1.0, 0.1)
  d <- generateData(theta, noObservations=100, initialState=0.0) 

  # Estimate the marginal posterior for phi
  pmhOutput <- particleMetropolisHastings(d$y,
    initialPhi=0.1, sigmav=1.0, sigmae=0.1, noParticles=50, 
    initialState=0.0, noIterations=noIterations, stepSize=0.10)

  # Plot the estimate
  nbins <- floor(sqrt(noIterations))
  par(mfrow=c(1, 1))
  hist(pmhOutput, breaks=nbins, main="", xlab=expression(phi), 
    ylab="marginal posterior", freq=FALSE, col="#7570B3")
}
\donttest{
  # Generates 100 observations from a linear state space model with
  # (phi, sigma_e, sigma_v) = (0.5, 1.0, 0.1) and zero initial state.
  theta <- c(0.5, 1.0, 0.1)
  d <- generateData(theta, noObservations=100, initialState=0.0) 

  # Estimate the marginal posterior for phi
  pmhOutput <- particleMetropolisHastings(d$y,
    initialPhi=0.1, sigmav=1.0, sigmae=0.1, noParticles=50, 
    initialState=0.0, noIterations=1000, stepSize=0.10)

  # Plot the estimate
  nbins <- floor(sqrt(1000))
  par(mfrow=c(1, 1))
  hist(pmhOutput, breaks=nbins, main="", xlab=expression(phi), 
    ylab="marginal posterior", freq=FALSE, col="#7570B3")
}
}
\references{
Dahlin, J. & Schön, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2017.
}
\author{
Johan Dahlin <uni (at) johandahlin.com.nospam>
}
\keyword{ts}
