% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getpaired}
\alias{getpaired}
\title{Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.}
\usage{
getpaired(list, rtcutoff = 10, ng = 10)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers}
}
\value{
list with tentative isotope, multi-chargers, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.
}
\examples{
\donttest{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
}
}
\seealso{
\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotpaired}}
}
