% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signpred.R
\name{signpred}
\alias{signpred}
\title{Graphical assessment of the stability of selected variables}
\usage{
signpred(
  matbin,
  pred.lablength = max(sapply(rownames(matbin), nchar)),
  labsize = 1,
  plotsize = 12
)
}
\arguments{
\item{matbin}{Matrix with 0 or 1 entries. Each row per predictor and a
column for every model. 0 means the predictor is not significant in the
model and 1 that, on the contrary, it is significant.}

\item{pred.lablength}{Maximum length of the predictors labels. Defaults to
full label length.}

\item{labsize}{Size of the predictors labels.}

\item{plotsize}{Global size of the graph.}
}
\value{
A plot window.
}
\description{
This fonctions plots, for each of the model, the
}
\details{
This function is based on the \code{\link[bipartite]{visweb}} function from
the bipartite package.
}
\examples{

signpred(matrix(rbinom(160,1,.2),ncol=8,dimnames=list(as.character(1:20),as.character(1:8))))

}
\references{
Vazquez, P.D., Chacoff, N.,P. and Cagnolo, L. (2009) Evaluating
multiple determinants of the structure of plant-animal mutualistic networks.
\emph{Ecology}, 90:2039-2046.
}
\seealso{
See Also \code{\link{visweb}}
}
\author{
Bernd Gruber with minor modifications from
Frédéric Bertrand\cr
\email{frederic.bertrand@math.unistra.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{hplot}
