% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly.R
\name{ggplotly}
\alias{ggplotly}
\title{Create plotly graphs using ggplot2 syntax}
\usage{
ggplotly(p = ggplot2::last_plot(), width = NULL, height = NULL,
  tooltip = "all", source = "A")
}
\arguments{
\item{p}{a ggplot object.}

\item{width}{Width of the plot in pixels (optional, defaults to automatic sizing).}

\item{height}{Height of the plot in pixels (optional, defaults to automatic sizing).}

\item{tooltip}{a character vector specifying which aesthetic mappings to show
in the tooltip. The default, "all", means show all the aesthetic mappings
(including the unofficial "text" aesthetic). The order of variables here will
also control the order they appear. For example, use
\code{tooltip = c("y", "x", "colour")} if you want y first, x second, and
colour last.}

\item{source}{Only relevant for \link{event_data}.}
}
\value{
a plotly object
}
\description{
See up-to-date documentation and examples at
\url{https://plot.ly/ggplot2}
}
\examples{
\dontrun{
# simple example
ggiris <- qplot(Petal.Width, Sepal.Length, data = iris, color = Species)
ggplotly(ggiris)

data(canada.cities, package = "maps")
viz <- ggplot(canada.cities, aes(long, lat)) +
  borders(regions = "canada") +
  coord_equal() +
  geom_point(aes(text = name, size = pop), colour = "red", alpha = 1/2)
 ggplotly(viz)
}

}
\author{
Carson Sievert
}
\seealso{
\link{signup}, \link{plot_ly}
}

