#' Graphing Nonlinear Relations Among Latent Variables from Structural Equation Mixture Models
#'
#' Contains a graphical user interface to generate the
#' diagnostic plots proposed by Bauer (2005) and Pek & Chalmers (2015) to investigate
#' nonlinear latent variable interactions in latent regression models.
#'
#' Creates plots which accompany Bauers (2005) semiparametric method of modeling
#' Structural Equation Mixture Models (SEMMs) by allowing researchers to visualize
#' potential nonlinear relationships between a latent predictor and outcome. Additionally,
#' a graphical user interface (GUI) is available for interactive use and is found in the function
#' \code{\link{plotSEMM_GUI}}.
#'
#' @name plotSEMM
#' @docType package
#' @useDynLib plotSEMM
#' @title Graphing Nonlinear Relations Among Latent Variables from Structural Equation Mixture Models
#' @author Bethany Kok and Phil Chalmers \email{rphilip.chalmers@@gmail.com}
#' @keywords package
#' @importFrom methods is
#' @importFrom utils read.table
#' @import shiny MplusAutomation plotrix Rcpp plyr stats graphics
NULL
