% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reScaleItem.R
\name{reScaleItem}
\alias{reScaleItem}
\title{Re-scales the category scale values and Phi after convergence of the nominal model}
\usage{
reScaleItem(model.fit, anchor)
}
\arguments{
\item{model.fit}{Model object for a nominal model}

\item{anchor}{Indicator of item(s) to place scaling constraint on.}
}
\value{
sNu         	Re-scaled category scale values

sPhi.mat	  	Re-scale phi matrix (conditional covariance matrix)
}
\description{
This auxillary function only applies to nominal models after estimating the
parameters of the model.  During estimation that scaling identification
constraint is put on conditional variances (i.e., phi_mm) such that they
equal 1. This function provide an alternative identification constraint
after the algorithm has converged. This function allow a user to tease
apart the strength and structure of associations. The alternative
scaling identification constraint is to set the sum of category scale
values equals 0 and the sum of squares equal to 1. The phi parameters
are adjusted accordingly. Only one item per trait should be selected for
the identification constraint and this is indicated by the object anchor.
}
\examples{

\donttest{
#--- 3 items from depression, anxiety, and stress scales
#    for 250 cases out of possible 1000
data(dass)
inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
inTraitAdj  <- matrix(1, nrow=1, ncol=1)
inItemTraitAdj <- matrix(1, nrow=9, ncol=1)
#--- nominal response model
n1 <- ple.lma(inData, model.type="nominal",inItemTraitAdj,inTraitAdj,tol=1e-03)
anchor <- c(1,0,0,0,0,0,0,0,0)
reScaleItem(model.fit=n1, anchor)

#--- Multidimensional models
inTraitAdj  <- matrix(1, nrow=3, ncol=3)
dpress <- matrix(c(1,0,0), nrow=3, ncol=3, byrow=TRUE)
anxiety <- matrix(c(0,1,0), nrow=3, ncol=3, byrow=TRUE)
stress <- matrix(c(0,0,1), nrow=3, ncol=3, byrow=TRUE)
das <- list(dpress, anxiety, stress)
inItemTraitAdj <- rbind(das[[1]], das[[2]], das[[3]])

n3 <- ple.lma(inData, model.type="nominal", inItemTraitAdj, inTraitAdj, tol=1e-03)
anchor <- c(1,0,0, 0,1,0, 1,0,0)
reScaleItem(model.fit=n3, anchor)

}

}
