% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPivot.R
\name{qpvt}
\alias{qpvt}
\title{Quickly build a basic pivot table.}
\usage{
qpvt(
  dataFrame,
  rows = NULL,
  columns = NULL,
  calculations = NULL,
  theme = NULL,
  replaceExistingStyles = FALSE,
  tableStyle = NULL,
  headingStyle = NULL,
  cellStyle = NULL,
  totalStyle = NULL,
  ...
)
}
\arguments{
\item{dataFrame}{The data frame containing the data to be summarised in the
pivot table.}

\item{rows}{A character vector of variable names to be plotted on the rows of
the pivot table, or "=" to specify the position of the calculations.}

\item{columns}{A character vector of variable names to be plotted on the
columns of the pivot table, or "=" to specify the position of the
calculations.}

\item{calculations}{One or more summary calculations to use to calculate the
values of the cells in the pivot table.}

\item{theme}{Either the name of a built-in theme (default, largeplain,
compact or blank/none) or a list which specifies the default formatting for
the table.}

\item{replaceExistingStyles}{TRUE to completely replace the default styling
with the specified tableStyle, headingStyle, cellStyle and/or totalStyle}

\item{tableStyle}{A list of CSS style declarations that apply to the table.}

\item{headingStyle}{A list of CSS style declarations that apply to the
heading cells in the table.}

\item{cellStyle}{A list of CSS style declarations that apply to the normal
cells in the table.}

\item{totalStyle}{A list of CSS style declarations that apply to the total
cells in the table.}

\item{...}{Additional arguments, currently format, formats, totals,
compatibility and/or argumentCheckMode.}
}
\value{
A pivot table.
}
\description{
The \code{qpvt} function builds a basic pivot table with one line of R.
}
\examples{
qpvt(bhmtrains, "TOC", "TrainCategory", "n()")
qpvt(bhmtrains, c("=", "TOC"), c("TrainCategory", "PowerType"),
     c("Number of Trains"="n()",
       "Maximum Speed"="max(SchedSpeedMPH, na.rm=TRUE)"))
}
